/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.mover;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.misc.SlotContainer;
import com.yogpc.qp.machine.mover.MoverEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class MoverContainer
extends AbstractContainerMenu {
    public static final String GUI_ID = "quarryplus:gui_mover";
    final MoverEntity entity;

    public MoverContainer(int syncId, Inventory inventory, BlockPos pos) {
        super(PlatformAccess.getAccess().registerObjects().moverContainer().get(), syncId);
        int col;
        this.entity = Objects.requireNonNull((MoverEntity)inventory.player.level().getBlockEntity(pos));
        for (col = 0; col < 2; ++col) {
            this.addSlot(new SlotContainer((Container)this.entity.inventory, col, 8 + col * 144, 40));
        }
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inventory, col + row * 9 + 9, 8 + col * 18, 104 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)inventory, col, 8 + col * 18, 162));
        }
        this.entity.syncToClient();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        int allSlots = this.entity.inventory.getContainerSize();
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack remain = slot.getItem();
            ItemStack slotContent = remain.copy();
            if (index < allSlots ? !this.moveItemStackTo(remain, allSlots, 36 + allSlots, true) : !this.moveItemStackTo(remain, 0, allSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (remain.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (remain.getCount() == slotContent.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, remain);
            return slotContent;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.entity.getBlockPos().distToCenterSqr((Position)player.position()) < 64.0;
    }
}

