/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import com.yogpc.qp.machine.placer.PlacerContainer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class PlacerScreen
extends AbstractContainerScreen<PlacerContainer> {
    private static final ResourceLocation LOCATION = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"textures/gui/replacer.png");

    public PlacerScreen(PlacerContainer c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int oneBox = 18;
        int x = ((PlacerContainer)this.getMenu()).startX - 1 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() % 3 * oneBox;
        int y = 16 + ((PlacerContainer)this.getMenu()).tile.getLastPlacedIndex() / 3 * oneBox;
        int pX = this.leftPos + x;
        int pY = this.topPos + y;
        graphics.blit(RenderPipelines.GUI_TEXTURED, LOCATION, pX, pY, 176.0f, 0.0f, oneBox, oneBox, 256, 256);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        this.renderModeLabel(graphics);
    }

    void renderModeLabel(GuiGraphics graphics) {
        AbstractPlacerTile.RedStoneMode mode = ((PlacerContainer)this.getMenu()).tile.redstoneMode;
        String pA = "Pulse";
        int x = 116;
        graphics.drawString(this.font, pA, x, 6, ARGB.opaque((int)0x404040), false);
        String rs = "";
        graphics.drawString(this.font, rs, x, 18, ARGB.opaque((int)0x404040), false);
        String only = mode.canBreak() && !mode.canPlace() ? "Break Only" : (mode.canPlace() && !mode.canBreak() ? "Place Only" : "");
        graphics.drawString(this.font, only, x, 30, ARGB.opaque((int)0x404040), false);
    }
}

