/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.machine.placer.AbstractPlacerTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public final class RemotePlacerEntity
extends AbstractPlacerTile {
    public static final String KEY_TARGET = "targetPos";
    @NotNull
    BlockPos targetPos;

    public RemotePlacerEntity(BlockPos pos, BlockState blockState) {
        super(pos, blockState);
        this.targetPos = pos.above();
    }

    @Override
    @NotNull
    protected BlockPos getTargetPos() {
        return this.targetPos;
    }

    @Override
    protected Direction getMachineFacing() {
        return Direction.UP;
    }

    @Override
    public void fromClientTag(ValueInput input) {
        super.fromClientTag(input);
        this.targetPos = (BlockPos)input.read(KEY_TARGET, BlockPos.CODEC).orElseThrow();
    }

    @Override
    public ValueOutput toClientTag(ValueOutput output) {
        output.store(KEY_TARGET, BlockPos.CODEC, (Object)this.targetPos);
        return super.toClientTag(output);
    }
}

