/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.placer;

import com.yogpc.qp.machine.placer.RemotePlacerEntity;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record RemotePlacerMessage(BlockPos pos, ResourceKey<Level> dim, BlockPos newTarget) implements CustomPacketPayload,
OnReceiveWithLevel
{
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)"remote_placer_message");
    public static final CustomPacketPayload.Type<RemotePlacerMessage> TYPE = new CustomPacketPayload.Type(NAME);
    public static final StreamCodec<RegistryFriendlyByteBuf, RemotePlacerMessage> STREAM_CODEC = CustomPacketPayload.codec(RemotePlacerMessage::write, RemotePlacerMessage::new);

    public RemotePlacerMessage(FriendlyByteBuf buf) {
        this(buf.readBlockPos(), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)buf.readResourceLocation()), buf.readBlockPos());
    }

    public RemotePlacerMessage(RemotePlacerEntity tile, BlockPos newTarget) {
        this(tile.getBlockPos(), (ResourceKey<Level>)Objects.requireNonNull(tile.getLevel()).dimension(), newTarget);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos).writeResourceLocation(this.dim.location());
        buf.writeBlockPos(this.newTarget);
    }

    @Override
    public void onReceive(Level level, Player player) {
        if (!level.dimension().equals(this.dim)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof RemotePlacerEntity) {
            RemotePlacerEntity placer = (RemotePlacerEntity)blockEntity;
            placer.targetPos = this.newTarget;
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

