/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;

final class ItemCountList
extends ObjectSelectionList<ItemCountRow> {
    final DebugStorageEntity storageEntity;

    public ItemCountList(Minecraft minecraft, int width, int height, int y, DebugStorageEntity storageEntity) {
        super(minecraft, width, height, y, 22);
        this.storageEntity = storageEntity;
        this.refreshEntries();
    }

    void refreshEntries() {
        this.replaceEntries(Stream.concat(this.storageEntity.storage.itemKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.ItemKeyCount)x$0)), this.storageEntity.storage.fluidKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.FluidKeyCount)x$0))).toList());
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected boolean isSelectedItem(int index) {
        return false;
    }

    public int getRowWidth() {
        return this.getWidth() - 10;
    }

    protected int scrollBarX() {
        return this.getRight() - 6;
    }

    protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemCountRow hovered;
        super.renderDecorations(guiGraphics, mouseX, mouseY);
        if (this.isMouseOver(mouseX, mouseY) && (hovered = (ItemCountRow)this.getHovered()) != null) {
            ItemStack stack = hovered.stack;
            Component component = stack.getStyledHoverName();
            guiGraphics.renderTooltip(this.minecraft.font, List.of(ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText())), mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, (ResourceLocation)stack.get(DataComponents.TOOLTIP_STYLE));
        }
    }

    class ItemCountRow
    extends ObjectSelectionList.Entry<ItemCountRow> {
        final ItemStack stack;
        final Component name;
        final long count;
        final String unit;

        ItemCountRow(MachineStorage.ItemKeyCount item) {
            this.stack = item.key().toStack(1);
            this.count = item.count();
            this.name = this.stack.getHoverName();
            this.unit = "";
        }

        ItemCountRow(MachineStorage.FluidKeyCount fluid) {
            this.stack = fluid.key().fluid().getBucket().getDefaultInstance();
            this.count = fluid.count() * 1000L / 81000L;
            this.name = PlatformAccess.getAccess().getFluidName(new FluidStackLike(fluid.key().fluid(), fluid.count(), fluid.key().patch()));
            this.unit = " mB";
        }

        public Component getNarration() {
            return this.name;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.renderFakeItem(this.stack, left, top);
            Component text = this.getNarration();
            int textWidth = ((ItemCountList)ItemCountList.this).minecraft.font.width((FormattedText)text);
            int textX = left + 20;
            int textY = top + 4;
            guiGraphics.drawString(((ItemCountList)ItemCountList.this).minecraft.font, text, textX, textY, ARGB.opaque((int)0xFFFFFF));
            guiGraphics.drawString(((ItemCountList)ItemCountList.this).minecraft.font, this.count + this.unit, textX + textWidth + 8, textY, ARGB.opaque((int)0xFFFFFF), true);
        }
    }
}

