/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.config.ConfigHolder;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineLootFunction;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.exp.ExpModuleItem;
import com.yogpc.qp.machine.marker.ChunkMarkerBlock;
import com.yogpc.qp.machine.marker.ChunkMarkerEntity;
import com.yogpc.qp.machine.marker.FlexibleMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerEntity;
import com.yogpc.qp.machine.marker.MarkerContainer;
import com.yogpc.qp.machine.marker.NormalMarkerBlock;
import com.yogpc.qp.machine.marker.NormalMarkerEntity;
import com.yogpc.qp.machine.misc.FrameBlock;
import com.yogpc.qp.machine.misc.GeneratorBlock;
import com.yogpc.qp.machine.misc.GeneratorEntity;
import com.yogpc.qp.machine.misc.SoftBlock;
import com.yogpc.qp.machine.misc.YSetterContainer;
import com.yogpc.qp.machine.module.BedrockModuleItem;
import com.yogpc.qp.machine.module.FilterModuleContainer;
import com.yogpc.qp.machine.module.FilterModuleItem;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.machine.module.PumpModuleItem;
import com.yogpc.qp.machine.module.RepeatTickModuleItem;
import com.yogpc.qp.machine.mover.MoverBlock;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.mover.MoverEntity;
import com.yogpc.qp.machine.placer.PlacerBlock;
import com.yogpc.qp.machine.placer.PlacerContainer;
import com.yogpc.qp.machine.placer.PlacerEntity;
import com.yogpc.qp.machine.placer.RemotePlacerBlock;
import com.yogpc.qp.machine.placer.RemotePlacerEntity;
import com.yogpc.qp.machine.quarry.QuarryBlock;
import com.yogpc.qp.machine.storage.DebugStorageBlock;
import com.yogpc.qp.machine.storage.DebugStorageContainer;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import com.yogpc.qp.neoforge.MiningNeoForge;
import com.yogpc.qp.neoforge.TransferNeoForge;
import com.yogpc.qp.neoforge.machine.advquarry.AdvQuarryEntityNeoForge;
import com.yogpc.qp.neoforge.machine.misc.CheckerItemNeoForge;
import com.yogpc.qp.neoforge.machine.misc.YSetterItemNeoForge;
import com.yogpc.qp.neoforge.machine.quarry.QuarryBlockNeoForge;
import com.yogpc.qp.neoforge.machine.quarry.QuarryEntityNeoForge;
import com.yogpc.qp.neoforge.packet.PacketHandler;
import com.yogpc.qp.recipe.FilterModuleExpandRecipe;
import com.yogpc.qp.recipe.InstallBedrockModuleRecipe;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.util.Lazy;

public final class PlatformAccessNeoForge
implements PlatformAccess {
    private final Lazy<PlatformAccess.RegisterObjects> itemsLazy = Lazy.lazy(RegisterObjectsNeoForge::new);
    private final Lazy<PacketHandler> packetHandlerLazy = Lazy.lazy(PacketHandler::new);
    private final Lazy<TransferNeoForge> transferLazy = Lazy.lazy(TransferNeoForge::new);
    private final ConfigHolder configLazy = new ConfigHolder(() -> QuarryConfig.load(this.configPath(), this::isInDevelopmentEnvironment));
    private final Lazy<PlatformAccess.Mining> miningLazy = Lazy.lazy(MiningNeoForge::new);

    @Override
    public String platformName() {
        return "NeoForge";
    }

    @Override
    public PlatformAccess.RegisterObjects registerObjects() {
        return (PlatformAccess.RegisterObjects)this.itemsLazy.get();
    }

    @Override
    public PlatformAccess.Packet packetHandler() {
        return (PlatformAccess.Packet)this.packetHandlerLazy.get();
    }

    @Override
    public Path configPath() {
        return FMLPaths.CONFIGDIR.get().resolve("%s.toml".formatted("quarryplus"));
    }

    @Override
    public Supplier<? extends QuarryConfig> getConfig() {
        return this.configLazy;
    }

    @Override
    public boolean isInDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public PlatformAccess.Transfer transfer() {
        return (PlatformAccess.Transfer)this.transferLazy.get();
    }

    @Override
    public FluidStackLike getFluidInItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BucketItem) {
            BucketItem bucketItem = (BucketItem)item;
            if (!stack.is(Items.BUCKET)) {
                return new FluidStackLike(bucketItem.content, 81000L, DataComponentPatch.EMPTY);
            }
        }
        return FluidStackLike.EMPTY;
    }

    @Override
    public Component getFluidName(FluidStackLike stack) {
        FluidStack s = new FluidStack(stack.fluid(), Math.clamp(stack.amount(), 0, Integer.MAX_VALUE));
        return s.getHoverName();
    }

    @Override
    public <T extends AbstractContainerMenu> void openGui(ServerPlayer player, GeneralScreenHandler<T> handler) {
        player.openMenu(handler, handler.pos());
    }

    @Override
    public PlatformAccess.Mining mining() {
        return (PlatformAccess.Mining)this.miningLazy.get();
    }

    @SubscribeEvent
    public void onWorldUnload(ServerStoppedEvent event) {
        this.configLazy.reset();
    }

    public static class RegisterObjectsNeoForge
    implements PlatformAccess.RegisterObjects {
        private static final DeferredRegister.Blocks BLOCK_REGISTER = DeferredRegister.createBlocks((String)"quarryplus");
        private static final DeferredRegister.Items ITEM_REGISTER = DeferredRegister.createItems((String)"quarryplus");
        private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"quarryplus");
        private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"quarryplus");
        private static final DeferredRegister<IngredientType<?>> INGREDIENT_REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"quarryplus");
        private static final DeferredRegister<CreativeModeTab> CREATIVE_TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"quarryplus");
        private static final DeferredRegister<LootItemFunctionType<?>> LOOT_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.LOOT_FUNCTION_TYPE, (String)"quarryplus");
        private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"quarryplus");
        private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"quarryplus");
        static final List<DeferredRegister<?>> REGISTER_LIST = List.of(BLOCK_REGISTER, ITEM_REGISTER, BLOCK_ENTITY_REGISTER, RECIPE_REGISTER, INGREDIENT_REGISTER, CREATIVE_TAB_REGISTER, LOOT_TYPE_REGISTER, DATA_COMPONENT_TYPE_REGISTER, MENU_TYPE_REGISTER);
        private static final Map<ResourceLocation, Supplier<? extends InCreativeTabs>> TAB_ITEMS = new HashMap<ResourceLocation, Supplier<? extends InCreativeTabs>>();
        private static final Map<String, EnableMap.EnableOrNot> ENABLE_MAP = new HashMap<String, EnableMap.EnableOrNot>();
        public static final DeferredBlock<QuarryBlockNeoForge> BLOCK_QUARRY = RegisterObjectsNeoForge.registerBlock("quarry", QuarryBlockNeoForge::new);
        public static final DeferredBlock<AdvQuarryBlock> BLOCK_ADV_QUARRY = RegisterObjectsNeoForge.registerBlock("adv_quarry", AdvQuarryBlock::new);
        public static final DeferredBlock<GeneratorBlock> BLOCK_GENERATOR = RegisterObjectsNeoForge.registerBlock("creative_generator", GeneratorBlock::new);
        public static final DeferredBlock<MoverBlock> BLOCK_MOVER = RegisterObjectsNeoForge.registerBlock("mover", MoverBlock::new);
        public static final DeferredBlock<PlacerBlock> BLOCK_PLACER = RegisterObjectsNeoForge.registerBlock("placer_plus", PlacerBlock::new);
        public static final DeferredBlock<RemotePlacerBlock> BLOCK_REMOTE_PLACER = RegisterObjectsNeoForge.registerBlock("remote_placer", RemotePlacerBlock::new);
        public static final DeferredBlock<NormalMarkerBlock> BLOCK_MARKER = RegisterObjectsNeoForge.registerBlock("marker", NormalMarkerBlock::new);
        public static final DeferredBlock<FlexibleMarkerBlock> BLOCK_FLEXIBLE_MARKER = RegisterObjectsNeoForge.registerBlock("flexible_marker", FlexibleMarkerBlock::new);
        public static final DeferredBlock<ChunkMarkerBlock> BLOCK_CHUNK_MARKER = RegisterObjectsNeoForge.registerBlock("chunk_marker", ChunkMarkerBlock::new);
        public static final DeferredItem<PumpModuleItem> ITEM_PUMP_MODULE = RegisterObjectsNeoForge.registerItem("pump_module", PumpModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final DeferredItem<BedrockModuleItem> ITEM_BEDROCK_MODULE = RegisterObjectsNeoForge.registerItem("remove_bedrock_module", BedrockModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final DeferredItem<ExpModuleItem> ITEM_EXP_MODULE = RegisterObjectsNeoForge.registerItem("exp_module", ExpModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final DeferredItem<RepeatTickModuleItem> ITEM_REPEAT_MODULE = RegisterObjectsNeoForge.registerItem("repeat_tick_module", RepeatTickModuleItem::new, EnableMap.EnableOrNot.CONFIG_OFF);
        public static final DeferredItem<FilterModuleItem> ITEM_FILTER_MODULE = RegisterObjectsNeoForge.registerItem("filter_module", FilterModuleItem::new, EnableMap.EnableOrNot.CONFIG_ON);
        public static final DeferredItem<CheckerItemNeoForge> ITEM_CHECKER = RegisterObjectsNeoForge.registerItem("status_checker", CheckerItemNeoForge::new, EnableMap.EnableOrNot.ALWAYS_ON);
        public static final DeferredItem<YSetterItemNeoForge> ITEM_Y_SET = RegisterObjectsNeoForge.registerItem("y_setter", YSetterItemNeoForge::new, EnableMap.EnableOrNot.ALWAYS_ON);
        public static final DeferredBlock<FrameBlock> BLOCK_FRAME = RegisterObjectsNeoForge.registerBlock("frame", FrameBlock::new);
        public static final DeferredBlock<SoftBlock> BLOCK_SOFT = RegisterObjectsNeoForge.registerBlock("soft_block", SoftBlock::new, b -> b.blockItem);
        public static final DeferredBlock<DebugStorageBlock> BLOCK_DEBUG_STORAGE = RegisterObjectsNeoForge.registerBlock("debug_storage", DebugStorageBlock::new);
        private static final Map<Class<? extends QpBlock>, Supplier<BlockEntityType<?>>> BLOCK_ENTITY_TYPES = new HashMap();
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<QuarryEntityNeoForge>> QUARRY_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"quarry", BLOCK_QUARRY, QuarryEntityNeoForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new QuarryBlockNeoForge[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<GeneratorEntity>> GENERATOR_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"creative_generator", BLOCK_GENERATOR, GeneratorEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new GeneratorBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<NormalMarkerEntity>> MARKER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"marker", BLOCK_MARKER, NormalMarkerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new NormalMarkerBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<MoverEntity>> MOVER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"mover", BLOCK_MOVER, MoverEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new MoverBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<FlexibleMarkerEntity>> FLEXIBLE_MARKER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"flexible_marker", BLOCK_FLEXIBLE_MARKER, FlexibleMarkerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new FlexibleMarkerBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<ChunkMarkerEntity>> CHUNK_MARKER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"chunk_marker", BLOCK_CHUNK_MARKER, ChunkMarkerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new ChunkMarkerBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<DebugStorageEntity>> DEBUG_STORAGE_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"debug_storage", BLOCK_DEBUG_STORAGE, DebugStorageEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.ALWAYS_ON, (QpBlock[])new DebugStorageBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<AdvQuarryEntityNeoForge>> ADV_QUARRY_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"adv_quarry", BLOCK_ADV_QUARRY, AdvQuarryEntityNeoForge::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new AdvQuarryBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PlacerEntity>> PLACER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"placer_plus", BLOCK_PLACER, PlacerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_ON, (QpBlock[])new PlacerBlock[0]);
        public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<RemotePlacerEntity>> REMOTE_PLACER_ENTITY_TYPE = RegisterObjectsNeoForge.registerBlockEntity((String)"remote_placer", BLOCK_REMOTE_PLACER, RemotePlacerEntity::new, (EnableMap.EnableOrNot)EnableMap.EnableOrNot.CONFIG_OFF, (QpBlock[])new RemotePlacerBlock[0]);
        public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_MODE_TAB = CREATIVE_TAB_REGISTER.register("quarryplus", () -> QuarryPlus.buildCreativeModeTab(CreativeModeTab.builder()).build());
        public static final DeferredHolder<MenuType<?>, MenuType<? extends YSetterContainer>> Y_SET_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_y_setter", YSetterContainer::new);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends MoverContainer>> MOVER_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_mover", MoverContainer::new);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends ModuleContainer>> MODULE_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_quarry_module", ModuleContainer::new);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends MarkerContainer>> FLEXIBLE_MARKER_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_flexible_marker", MarkerContainer::createFlexibleMarkerContainer);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends MarkerContainer>> CHUNK_MARKER_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_chunk_marker", MarkerContainer::createChunkMarkerContainer);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends DebugStorageContainer>> DEBUG_STORAGE_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_debug_storage", DebugStorageContainer::new);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends AdvQuarryContainer>> ADV_QUARRY_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_adv_quarry", AdvQuarryContainer::new);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends FilterModuleContainer>> FILTER_MODULE_MENU_TYPE = MENU_TYPE_REGISTER.register("gui_filter_module", () -> IMenuTypeExtension.create((windowId, inv, data) -> new FilterModuleContainer(windowId, inv, inv.getSelectedItem())));
        public static final DeferredHolder<MenuType<?>, MenuType<? extends PlacerContainer>> PLACER_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_placer_plus", PlacerContainer::createPlacerContainer);
        public static final DeferredHolder<MenuType<?>, MenuType<? extends PlacerContainer>> REMOTE_PLACER_MENU_TYPE = RegisterObjectsNeoForge.registerMenu("gui_remote_placer", PlacerContainer::createRemotePlacerContainer);
        public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<? extends MachineLootFunction>> MACHINE_LOOT_FUNCTION = LOOT_TYPE_REGISTER.register("machine_loot_function", () -> new LootItemFunctionType(MachineLootFunction.SERIALIZER));
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<InstallBedrockModuleRecipe>> INSTALL_BEDROCK_MODULE_RECIPE = RECIPE_REGISTER.register("install_bedrock_module_recipe", () -> InstallBedrockModuleRecipe.SERIALIZER);
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<FilterModuleExpandRecipe>> FILTER_MODULE_EXPAND_RECIPE = RECIPE_REGISTER.register(FilterModuleExpandRecipe.LOCATION.getPath(), () -> FilterModuleExpandRecipe.SERIALIZER);

        private static <T extends QpBlock> DeferredBlock<T> registerBlock(String name, Supplier<T> supplier) {
            return RegisterObjectsNeoForge.registerBlock(name, supplier, b -> b.blockItem);
        }

        private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> supplier, Function<T, ? extends BlockItem> itemGetter) {
            DeferredBlock block = BLOCK_REGISTER.register(name, supplier);
            ITEM_REGISTER.register(name, () -> (BlockItem)itemGetter.apply((Block)block.get()));
            TAB_ITEMS.put(ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)name), (Supplier<? extends InCreativeTabs>)block);
            return block;
        }

        private static <T extends Item> DeferredItem<T> registerItem(String name, Supplier<T> supplier, EnableMap.EnableOrNot enableOrNot) {
            DeferredItem item = ITEM_REGISTER.register(name, supplier);
            TAB_ITEMS.put(ResourceLocation.fromNamespaceAndPath((String)"quarryplus", (String)name), (Supplier<? extends InCreativeTabs>)item);
            ENABLE_MAP.put(name, enableOrNot);
            return item;
        }

        @SafeVarargs
        private static <T extends QpBlock, U extends BlockEntity> DeferredHolder<BlockEntityType<?>, BlockEntityType<U>> registerBlockEntity(String name, DeferredBlock<T> block, BlockEntityType.BlockEntitySupplier<U> factory, EnableMap.EnableOrNot enableOrNot, T ... dummy) {
            DeferredHolder entityType = BLOCK_ENTITY_REGISTER.register(name, () -> new BlockEntityType(factory, new Block[]{(Block)block.get()}));
            BLOCK_ENTITY_TYPES.put((Class<? extends QpBlock>)dummy.getClass().componentType(), (Supplier)entityType);
            ENABLE_MAP.put(name, enableOrNot);
            return entityType;
        }

        private static <T extends AbstractContainerMenu> DeferredHolder<MenuType<?>, MenuType<? extends T>> registerMenu(String name, GeneralScreenHandler.ContainerFactory<T> factory) {
            return MENU_TYPE_REGISTER.register(name, () -> IMenuTypeExtension.create((i, inventory, friendlyByteBuf) -> factory.create(i, inventory, friendlyByteBuf.readBlockPos())));
        }

        @Override
        public Supplier<? extends QuarryBlock> quarryBlock() {
            return BLOCK_QUARRY;
        }

        @Override
        public Supplier<? extends FrameBlock> frameBlock() {
            return BLOCK_FRAME;
        }

        @Override
        public Supplier<? extends GeneratorBlock> generatorBlock() {
            return BLOCK_GENERATOR;
        }

        @Override
        public Supplier<? extends NormalMarkerBlock> markerBlock() {
            return BLOCK_MARKER;
        }

        @Override
        public Supplier<? extends MoverBlock> moverBlock() {
            return BLOCK_MOVER;
        }

        @Override
        public Supplier<? extends FlexibleMarkerBlock> flexibleMarkerBlock() {
            return BLOCK_FLEXIBLE_MARKER;
        }

        @Override
        public Supplier<? extends ChunkMarkerBlock> chunkMarkerBlock() {
            return BLOCK_CHUNK_MARKER;
        }

        @Override
        public Supplier<? extends DebugStorageBlock> debugStorageBlock() {
            return BLOCK_DEBUG_STORAGE;
        }

        @Override
        public Supplier<? extends AdvQuarryBlock> advQuarryBlock() {
            return BLOCK_ADV_QUARRY;
        }

        @Override
        public Supplier<? extends SoftBlock> softBlock() {
            return BLOCK_SOFT;
        }

        @Override
        public Supplier<? extends PlacerBlock> placerBlock() {
            return BLOCK_PLACER;
        }

        @Override
        public Supplier<? extends RemotePlacerBlock> remotePlacerBlock() {
            return BLOCK_REMOTE_PLACER;
        }

        @Override
        public Optional<BlockEntityType<?>> getBlockEntityType(QpBlock block) {
            Supplier<BlockEntityType<?>> t = BLOCK_ENTITY_TYPES.get(block.getClass());
            if (t == null) {
                QuarryPlus.LOGGER.warn("Unknown block type: {}", (Object)block.name);
                return Optional.empty();
            }
            return Optional.of(t.get());
        }

        @Override
        public Map<String, EnableMap.EnableOrNot> defaultEnableSetting() {
            return ENABLE_MAP;
        }

        @Override
        public Supplier<? extends BedrockModuleItem> bedrockModuleItem() {
            return ITEM_BEDROCK_MODULE;
        }

        @Override
        public Supplier<? extends FilterModuleItem> filterModuleItem() {
            return ITEM_FILTER_MODULE;
        }

        @Override
        public Stream<Map.Entry<ResourceLocation, Supplier<? extends InCreativeTabs>>> allItems() {
            return TAB_ITEMS.entrySet().stream();
        }

        @Override
        public Supplier<MenuType<? extends YSetterContainer>> ySetterContainer() {
            return Y_SET_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MoverContainer>> moverContainer() {
            return MOVER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends ModuleContainer>> moduleContainer() {
            return MODULE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MarkerContainer>> flexibleMarkerContainer() {
            return FLEXIBLE_MARKER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends MarkerContainer>> chunkMarkerContainer() {
            return CHUNK_MARKER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends DebugStorageContainer>> debugStorageContainer() {
            return DEBUG_STORAGE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends AdvQuarryContainer>> advQuarryContainer() {
            return ADV_QUARRY_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends FilterModuleContainer>> filterModuleContainer() {
            return FILTER_MODULE_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends PlacerContainer>> placerContainer() {
            return PLACER_MENU_TYPE;
        }

        @Override
        public Supplier<MenuType<? extends PlacerContainer>> remotePlacerContainer() {
            return REMOTE_PLACER_MENU_TYPE;
        }

        @Override
        public Supplier<LootItemFunctionType<? extends MachineLootFunction>> machineLootFunction() {
            return MACHINE_LOOT_FUNCTION;
        }

        static {
            for (Map.Entry<ResourceLocation, DataComponentType<?>> e : QuarryDataComponents.ALL.entrySet()) {
                DATA_COMPONENT_TYPE_REGISTER.register(e.getKey().getPath(), e::getValue);
            }
        }
    }
}

