/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.neoforge.packet;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machine.advquarry.AdvActionActionMessage;
import com.yogpc.qp.machine.advquarry.AdvActionSyncMessage;
import com.yogpc.qp.machine.advquarry.AdvQuarryInitialAskMessage;
import com.yogpc.qp.machine.marker.ChunkMarkerMessage;
import com.yogpc.qp.machine.marker.FlexibleMarkerMessage;
import com.yogpc.qp.machine.mover.MoverMessage;
import com.yogpc.qp.machine.placer.RemotePlacerMessage;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.OnReceiveWithLevel;
import com.yogpc.qp.packet.YSetterMessage;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.gametest.framework.GameTestServer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public final class PacketHandler
implements PlatformAccess.Packet {
    private static final int PROTOCOL = 1;
    private static final Proxy PROXY = ProxyProvider.getInstance();

    public static void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("quarryplus").versioned(String.valueOf(1));
        registrar.playToClient(ClientSyncMessage.TYPE, ClientSyncMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(YSetterMessage.TYPE, YSetterMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(MoverMessage.TYPE, MoverMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(FlexibleMarkerMessage.TYPE, FlexibleMarkerMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(ChunkMarkerMessage.TYPE, ChunkMarkerMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(AdvActionActionMessage.TYPE, AdvActionActionMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(AdvActionSyncMessage.TYPE, AdvActionSyncMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToClient(AdvQuarryInitialAskMessage.TYPE, AdvQuarryInitialAskMessage.STREAM_CODEC, PacketHandler::onReceive);
        registrar.playToServer(RemotePlacerMessage.TYPE, RemotePlacerMessage.STREAM_CODEC, PacketHandler::onReceive);
    }

    private static void onReceive(OnReceiveWithLevel message, IPayloadContext context) {
        context.enqueueWork(() -> PROXY.getPacketPlayer(context).ifPresent(player -> message.onReceive(player.level(), (Player)player)));
    }

    @Override
    public void sendToClientWorld(@NotNull CustomPacketPayload message, @NotNull Level level) {
        if (level.getServer() instanceof GameTestServer) {
            QuarryPlus.LOGGER.debug("PacketHandler#sendToClient is called in GameTestServer for {}", (Object)message.getClass().getSimpleName());
        } else if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            QuarryPlus.LOGGER.error("PacketHandler#sendToClient is called in client level");
        }
    }

    @Override
    public void sendToClientPlayer(@NotNull CustomPacketPayload message, @NotNull ServerPlayer player) {
        if (player.level().getServer() instanceof GameTestServer) {
            QuarryPlus.LOGGER.debug("PacketHandler#sendToClientPlayer is called in GameTestServer for {}", (Object)message.getClass().getSimpleName());
            return;
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToServer(@NotNull CustomPacketPayload message) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static abstract class Proxy {
        private Proxy() {
        }

        @NotNull
        abstract Optional<Player> getPacketPlayer(@NotNull IPayloadContext var1);
    }

    private static class ProxyProvider {
        private ProxyProvider() {
        }

        @NotNull
        private static Proxy getInstance() {
            return switch (FMLLoader.getDist()) {
                default -> throw new MatchException(null, null);
                case Dist.CLIENT -> new ClientSupplier().get();
                case Dist.DEDICATED_SERVER -> new ServerSupplier().get();
            };
        }

        private static class ClientSupplier {
            private ClientSupplier() {
            }

            Proxy get() {
                return new ProxyClient();
            }
        }

        private static class ServerSupplier {
            private ServerSupplier() {
            }

            Proxy get() {
                return new ProxyServer();
            }
        }
    }

    private static class ProxyClient
    extends Proxy {
        private ProxyClient() {
        }

        @Override
        @NotNull
        Optional<Player> getPacketPlayer(@NotNull IPayloadContext context) {
            return Optional.of(context.player()).or(() -> Optional.ofNullable(Minecraft.getInstance().player));
        }
    }

    private static class ProxyServer
    extends Proxy {
        private ProxyServer() {
        }

        @Override
        @NotNull
        Optional<Player> getPacketPlayer(@NotNull IPayloadContext context) {
            return Optional.of(context.player());
        }
    }
}

