/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.QpBlock;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallBedrockModuleRecipe
implements CraftingRecipe {
    public static final String NAME = "install_bedrock_module_recipe";
    public static final RecipeSerializer<InstallBedrockModuleRecipe> SERIALIZER = new Serializer();
    private final QpBlock block;
    final ItemStack result;
    final List<Ingredient> ingredients;
    final Lazy<PlacementInfo> placementInfo;

    public InstallBedrockModuleRecipe(QpBlock block) {
        this.block = block;
        this.ingredients = InstallBedrockModuleRecipe.getIngredients(block);
        this.result = InstallBedrockModuleRecipe.resultItem(block);
        this.placementInfo = Lazy.lazy(() -> PlacementInfo.create(this.ingredients));
    }

    InstallBedrockModuleRecipe(ResourceLocation targetBlockId) {
        this(InstallBedrockModuleRecipe.fromId(targetBlockId));
    }

    public boolean matches(CraftingInput input, Level level) {
        if (!input.stackedContents().canCraft((Recipe)this, null)) {
            return false;
        }
        ItemStack stack = input.items().stream().filter(s -> s.is((Item)this.block.blockItem)).findFirst().map(ItemStack::copy).orElse(ItemStack.EMPTY);
        Boolean installed = (Boolean)stack.getOrDefault(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)Boolean.FALSE);
        return installed == false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack stack = input.items().stream().filter(s -> s.is((Item)this.block.blockItem)).findFirst().map(ItemStack::copy).orElse(ItemStack.EMPTY);
        stack.set(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)true);
        return stack;
    }

    public RecipeSerializer<InstallBedrockModuleRecipe> getSerializer() {
        return SERIALIZER;
    }

    public PlacementInfo placementInfo() {
        return (PlacementInfo)this.placementInfo.get();
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public String group() {
        return "quarryplus:install_bedrock_module_recipe";
    }

    private static QpBlock fromId(ResourceLocation blockId) {
        Block block = (Block)BuiltInRegistries.BLOCK.getValue(blockId);
        if (block instanceof QpBlock) {
            QpBlock qpBlock = (QpBlock)block;
            return qpBlock;
        }
        throw new IllegalArgumentException("Invalid block %s(%s)".formatted(block, blockId));
    }

    ResourceLocation getTargetBlockId() {
        return this.block.name;
    }

    @NotNull
    private static NonNullList<Ingredient> getIngredients(QpBlock block) {
        return NonNullList.of((Object)Ingredient.of((ItemLike)block), (Object[])new Ingredient[]{Ingredient.of((ItemLike)((ItemLike)PlatformAccess.getAccess().registerObjects().bedrockModuleItem().get()))});
    }

    static ItemStack resultItem(QpBlock block) {
        ItemStack stack = new ItemStack((ItemLike)block);
        stack.set(QuarryDataComponents.QUARRY_REMOVE_BEDROCK_COMPONENT, (Object)true);
        return stack;
    }

    public static Builder builder(QpBlock block) {
        return new Builder(block);
    }

    public static final class Builder
    implements RecipeBuilder {
        private final QpBlock block;
        private final RecipeCategory category = RecipeCategory.MISC;
        private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

        public Builder(QpBlock block) {
            this.block = block;
        }

        public Builder unlockedBy(String name, Criterion<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        public Builder group(@Nullable String groupName) {
            throw new UnsupportedOperationException("Group definition is not supported");
        }

        public Item getResult() {
            return this.block.blockItem;
        }

        public void save(RecipeOutput recipeOutput, ResourceKey<Recipe<?>> resourceKey) {
            Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(resourceKey)).rewards(AdvancementRewards.Builder.recipe(resourceKey)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
            InstallBedrockModuleRecipe recipe = new InstallBedrockModuleRecipe(this.block);
            AdvancementHolder advancement = builder.build(resourceKey.location().withPrefix("recipes/" + this.category.getFolderName() + "/"));
            recipeOutput.accept(resourceKey, (Recipe)recipe, advancement);
        }
    }

    private static final class Serializer
    implements RecipeSerializer<InstallBedrockModuleRecipe> {
        public static final MapCodec<InstallBedrockModuleRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)RecordCodecBuilder.of(InstallBedrockModuleRecipe::getTargetBlockId, (String)"target", (Codec)ResourceLocation.CODEC)).apply((Applicative)i, InstallBedrockModuleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, InstallBedrockModuleRecipe> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(InstallBedrockModuleRecipe::new, InstallBedrockModuleRecipe::getTargetBlockId).cast();

        private Serializer() {
        }

        public MapCodec<InstallBedrockModuleRecipe> codec() {
            return CODEC;
        }

        @Deprecated
        public StreamCodec<RegistryFriendlyByteBuf, InstallBedrockModuleRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

