/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.inventory;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.services.CommonAbstractions;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BarteringStationMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;

    public BarteringStationMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(21), (ContainerData)new SimpleContainerData(2));
    }

    public BarteringStationMenu(int containerId, Inventory inventory, Container container, ContainerData containerData) {
        super((MenuType)ModRegistry.BARTERING_STATION_MENU_TYPE.value(), containerId);
        BarteringStationMenu.checkContainerSize((Container)container, (int)21);
        BarteringStationMenu.checkContainerDataCount((ContainerData)containerData, (int)2);
        this.container = container;
        this.data = containerData;
        this.addSlots(container, inventory);
        this.addDataSlots(containerData);
    }

    private void addSlots(Container container, Inventory inventory) {
        int i;
        for (i = 0; i < 6; ++i) {
            this.addSlot(new Slot(this, container, i, 11 + i % 2 * 18, 17 + i / 2 * 18){

                public boolean mayPlace(ItemStack stack) {
                    return CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
                }
            });
        }
        for (i = 6; i < 21; ++i) {
            this.addSlot(new Slot(this, container, i, 77 + (i - 6) % 5 * 18, 17 + (i - 6) / 5 * 18){

                public boolean mayPlace(ItemStack stack) {
                    return false;
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= 6 && index < 21) {
                if (!this.moveItemStackTo(itemstack1, 21, 57, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index >= 21 ? (CommonAbstractions.INSTANCE.isPiglinCurrency(itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 6, false) : (index < 48 ? !this.moveItemStackTo(itemstack1, 48, 57, false) : index < 57 && !this.moveItemStackTo(itemstack1, 21, 48, false))) : !this.moveItemStackTo(itemstack1, 21, 57, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public int getTopArrowProgress() {
        return (((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - this.data.get(0)) * 2 * 24 / ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
    }

    public int getBottomArrowProgress() {
        return (((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - this.data.get(0)) * 2 * 24 / ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay - 24;
    }

    public float getCooldownProgress() {
        return (float)this.data.get(0) / (float)((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
    }

    public int getNearbyPiglins() {
        return this.data.get(1);
    }
}

