/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block;

import com.mojang.serialization.MapCodec;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.level.block.entity.BarteringStationBlockEntity;
import fuzs.puzzleslib.api.block.v1.entity.TickingEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class BarteringStationBlock
extends BaseEntityBlock
implements TickingEntityBlock<BarteringStationBlockEntity> {
    public static final MapCodec<BarteringStationBlock> CODEC = BarteringStationBlock.simpleCodec(BarteringStationBlock::new);

    public BarteringStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType<? extends BarteringStationBlockEntity> getBlockEntityType() {
        return (BlockEntityType)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.value();
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BarteringStationBlockEntity) {
            BarteringStationBlockEntity blockEntity2 = (BarteringStationBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
        }
        return InteractionResult.CONSUME;
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, boolean bl) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockState, (Level)serverLevel, (BlockPos)blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(blockPos));
    }

    public boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

