/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.ModelPartInjector;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    private boolean setupFirstpersonArms = false;

    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="RETURN")})
    public void extractRenderState(AbstractClientPlayer abstractClientPlayer, PlayerRenderState playerRenderState, float f, CallbackInfo ci) {
        PlayerModel playerModel = (PlayerModel)this.getModel();
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        boolean slim = ((PlayerEntityModelAccessor)this.getModel()).hasThinArms();
        ((ModelPartInjector)playerModel.hat).setInjectedMesh(null, null);
        ((ModelPartInjector)playerModel.jacket).setInjectedMesh(null, null);
        ((ModelPartInjector)playerModel.leftSleeve).setInjectedMesh(null, null);
        ((ModelPartInjector)playerModel.rightSleeve).setInjectedMesh(null, null);
        ((ModelPartInjector)playerModel.leftPants).setInjectedMesh(null, null);
        ((ModelPartInjector)playerModel.rightPants).setInjectedMesh(null, null);
        if (Minecraft.getInstance().player == null || abstractClientPlayer.distanceToSqr(Minecraft.getInstance().gameRenderer.getMainCamera().getPosition()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        if (!SkinUtil.setup3dLayers(abstractClientPlayer, settings, slim)) {
            return;
        }
        ItemStack itemStack = abstractClientPlayer.getItemBySlot(EquipmentSlot.HEAD);
        if (SkinLayersModBase.config.enableHat && (itemStack == null || !SkinLayersModBase.hideHeadLayers.contains(itemStack.getItem()))) {
            ((ModelPartInjector)playerModel.hat).setInjectedMesh(settings.getHeadMesh(), OffsetProvider.HEAD);
        }
        if (SkinLayersModBase.config.enableJacket) {
            ((ModelPartInjector)playerModel.jacket).setInjectedMesh(settings.getTorsoMesh(), OffsetProvider.BODY);
        }
        if (SkinLayersModBase.config.enableLeftSleeve) {
            ((ModelPartInjector)playerModel.leftSleeve).setInjectedMesh(settings.getLeftArmMesh(), slim ? OffsetProvider.LEFT_ARM_SLIM : OffsetProvider.LEFT_ARM);
        }
        if (SkinLayersModBase.config.enableRightSleeve) {
            ((ModelPartInjector)playerModel.rightSleeve).setInjectedMesh(settings.getRightArmMesh(), slim ? OffsetProvider.RIGHT_ARM_SLIM : OffsetProvider.RIGHT_ARM);
        }
        if (SkinLayersModBase.config.enableLeftPants) {
            ((ModelPartInjector)playerModel.leftPants).setInjectedMesh(settings.getLeftLegMesh(), OffsetProvider.LEFT_LEG);
        }
        if (SkinLayersModBase.config.enableRightPants) {
            ((ModelPartInjector)playerModel.rightPants).setInjectedMesh(settings.getRightLegMesh(), OffsetProvider.RIGHT_LEG);
        }
    }

    @Inject(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="HEAD")})
    private void renderHandStart(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ResourceLocation resourceLocation, ModelPart arm, boolean bl, CallbackInfo info) {
        LocalPlayer abstractClientPlayer = Minecraft.getInstance().player;
        ModelPart sleeve = arm == ((PlayerModel)this.getModel()).leftArm ? ((PlayerModel)this.getModel()).leftSleeve : ((PlayerModel)this.getModel()).rightSleeve;
        PlayerSettings settings = (PlayerSettings)abstractClientPlayer;
        boolean slim = ((PlayerEntityModelAccessor)this.getModel()).hasThinArms();
        ((ModelPartInjector)sleeve).setInjectedMesh(null, null);
        if (!SkinUtil.setup3dLayers((AbstractClientPlayer)abstractClientPlayer, settings, slim)) {
            return;
        }
        this.setupFirstpersonArms = true;
        if (arm == ((PlayerModel)this.getModel()).leftArm) {
            if (SkinLayersModBase.config.enableLeftSleeve) {
                ((ModelPartInjector)sleeve).setInjectedMesh(settings.getLeftArmMesh(), slim ? OffsetProvider.FIRSTPERSON_LEFT_ARM_SLIM : OffsetProvider.FIRSTPERSON_LEFT_ARM);
            }
        } else if (SkinLayersModBase.config.enableRightSleeve) {
            ((ModelPartInjector)sleeve).setInjectedMesh(settings.getRightArmMesh(), slim ? OffsetProvider.FIRSTPERSON_RIGHT_ARM_SLIM : OffsetProvider.FIRSTPERSON_RIGHT_ARM);
        }
    }
}

