/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.handler;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public final class ConfigHandler {
    private static ModConfigSpec.IntValue maxBridgeDistance;
    private static ModConfigSpec.IntValue bridgeDroopFactor;
    private static ModConfigSpec.DoubleValue bridgeYOffset;
    private static ModConfigSpec.BooleanValue breakThroughBlocks;
    private static ModConfigSpec.BooleanValue ignoreSlopeWarnings;
    private static ModConfigSpec.IntValue slabsPerBridge;
    private static ModConfigSpec.IntValue ropePerBridge;
    private static ModConfigSpec.IntValue woodPerLadder;
    private static ModConfigSpec.IntValue ropePerLadder;
    private static ModConfigSpec.IntValue bridgeDamage;
    private static ModConfigSpec.IntValue ladderDamage;
    public static final ConfigHandler SERVER;
    public static final ModConfigSpec SERVER_SPEC;

    public ConfigHandler(ModConfigSpec.Builder builder) {
        builder.push("general");
        maxBridgeDistance = builder.comment("Max length of bridges made be Grappling Gun.").defineInRange("maxBridgeDistance", 400, 1, 1000);
        bridgeDroopFactor = builder.comment("Percent of slack the bridge will have, causing it to hang.").defineInRange("bridgeDroopFactor", 100, 0, 100);
        bridgeYOffset = builder.comment("Generated bridges will be raised or lowered by this amount in blocks.\nDefault is just below user's feet.").defineInRange("bridgeYOffset", -0.3, -1.0, 1.0);
        breakThroughBlocks = builder.comment("If enabled, all blocks that dare stand in a bridge's way will be broken.\nVery useful in creative mode.").define("breakThroughBlocks", false);
        ignoreSlopeWarnings = builder.comment("Set true to ignore all slope warnings and allow building of very steep bridges.").define("ignoreSlopeWarnings", false);
        slabsPerBridge = builder.comment("Slabs consumed for each bridge block built.").defineInRange("slabsPerBridge", 1, 0, 10);
        ropePerBridge = builder.comment("String consumed for each bridge block built.").defineInRange("ropePerBridge", 2, 0, 20);
        woodPerLadder = builder.comment("Wood consumed for each ladder block built.").defineInRange("woodPerLadder", 1, 0, 10);
        ropePerLadder = builder.comment("Rope consumed for each ladder block built.").defineInRange("ropePerLadder", 2, 0, 20);
        bridgeDamage = builder.comment("How much the Ladder Gun is damaged after creating each ladder.").defineInRange("damageForLadder", 1, 0, 64);
        ladderDamage = builder.comment("How much the Bridge Gun is damaged after creating each ladder.").defineInRange("damageForBridge", 1, 0, 64);
        builder.pop();
    }

    public static boolean isIgnoreSlopeWarnings() {
        return (Boolean)ignoreSlopeWarnings.get();
    }

    public static int getBridgeDroopFactor() {
        return (Integer)bridgeDroopFactor.get();
    }

    public static double getBridgeYOffset() {
        return (Double)bridgeYOffset.get();
    }

    public static boolean isBreakThroughBlocks() {
        return (Boolean)breakThroughBlocks.get();
    }

    public static int getMaxBridgeDistance() {
        return (Integer)maxBridgeDistance.get();
    }

    public static int getRopePerLadder() {
        return (Integer)ropePerLadder.get();
    }

    public static int getSlabsPerBridge() {
        return (Integer)slabsPerBridge.get();
    }

    public static int getRopePerBridge() {
        return (Integer)ropePerBridge.get();
    }

    public static int getWoodPerLadder() {
        return (Integer)woodPerLadder.get();
    }

    public static int getLadderDamage() {
        return (Integer)ladderDamage.get();
    }

    public static int getBridgeDamage() {
        return (Integer)bridgeDamage.get();
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ConfigHandler::new);
        SERVER_SPEC = (ModConfigSpec)specPair.getRight();
        SERVER = (ConfigHandler)specPair.getLeft();
    }
}

