/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.item;

import com.mrtrollnugnug.ropebridge.block.RopeBridgeBlock;
import com.mrtrollnugnug.ropebridge.handler.BridgeBuildingHandler;
import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import com.mrtrollnugnug.ropebridge.item.ItemBuilder;
import com.mrtrollnugnug.ropebridge.lib.ModUtils;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemBridgeBuilder
extends ItemBuilder {
    public ItemBridgeBuilder(Item.Properties properties) {
        super(properties);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
        if (livingEntity.level().isClientSide && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemBridgeBuilder.rotatePlayerTowards(player, ItemBridgeBuilder.getNearestYaw(player));
        }
    }

    private static void rotatePlayerTowards(Player player, float target) {
        float yaw = player.getYRot() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        ItemBridgeBuilder.rotatePlayerTo(player, yaw + (target - yaw) / 4.0f);
    }

    private static void rotatePlayerTo(Player player, float yaw) {
        float original = player.getYRot();
        player.setYRot(yaw);
        player.yRotO += player.getYRot() - original;
    }

    private static float getNearestYaw(Player player) {
        float yaw = player.getYRot() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw < 45.0f) {
            return 0.0f;
        }
        if (yaw > 45.0f && yaw <= 135.0f) {
            return 90.0f;
        }
        if (yaw > 135.0f && yaw <= 225.0f) {
            return 180.0f;
        }
        if (yaw > 225.0f && yaw <= 315.0f) {
            return 270.0f;
        }
        return 360.0f;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!level.isClientSide && this.getUseDuration(stack, livingEntity) - timeCharged > 10) {
                if (!player.onGround()) {
                    ModUtils.tellPlayer(player, "chat.ropebridge.info.notonground", new Object[0]);
                } else {
                    HitResult hit = ItemBridgeBuilder.trace(player);
                    if (hit instanceof BlockHitResult) {
                        BlockHitResult blockHitResult = (BlockHitResult)hit;
                        BlockPos floored = BlockPos.containing((double)player.getX(), (double)(player.getY() - 1.0), (double)player.getZ()).below();
                        BlockPos target = blockHitResult.getBlockPos();
                        BridgeBuildingHandler.newBridge(player, player.getMainHandItem(), floored, target);
                        level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), (SoundEvent)ContentHandler.swoosh.get(), SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (ItemBridgeBuilder.isBridgeBlock(state.getBlock())) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.literal((String)"- Hold right-click to build"));
        tooltipAdder.accept((Component)Component.literal((String)"- Sneak to break whole bridge"));
    }

    private static boolean isBridgeBlock(Block block) {
        return block instanceof RopeBridgeBlock;
    }
}

