/*
 * Decompiled with CFR 0.152.
 */
package com.mrtrollnugnug.ropebridge.lib;

import com.mrtrollnugnug.ropebridge.handler.ContentHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModUtils {
    private ModUtils() {
    }

    public static void tellPlayer(Player sender, String message, Object ... params) {
        sender.displayClientMessage((Component)Component.translatable((String)message, (Object[])params), false);
    }

    public static Block getSlabToUse(Player player) {
        for (ItemStack stack : player.getInventory().getNonEquipmentItems()) {
            Block block;
            if (stack.isEmpty() || !stack.is(ItemTags.WOODEN_SLABS) || !ModUtils.isInMap(block = Block.byItem((Item)stack.getItem()))) continue;
            return block;
        }
        return Blocks.OAK_SLAB;
    }

    public static boolean isInMap(Block block) {
        return block.builtInRegistryHolder().getData(ContentHandler.SLAB_MAP) != null;
    }

    public static void unlockAdvancement(Player player, ResourceLocation advancementId) {
        AdvancementProgress advancementprogress;
        AdvancementHolder advancementHolder;
        ServerPlayer serverPlayer;
        MinecraftServer server;
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).getServer()) != null && (advancementHolder = server.getAdvancements().get(advancementId)) != null && !(advancementprogress = serverPlayer.getAdvancements().getOrStartProgress(advancementHolder)).isDone()) {
            for (String s : advancementprogress.getRemainingCriteria()) {
                serverPlayer.getAdvancements().award(advancementHolder, s);
            }
        }
    }
}

