/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.MultiItemStackHandler;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easypiglins.blocks.tileentity.PiglinTileentity;
import de.maxhenkel.easypiglins.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easypiglins.corelib.inventory.ItemListInventory;
import de.maxhenkel.easypiglins.corelib.item.ItemUtils;
import de.maxhenkel.easypiglins.gui.BarterSlot;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BartererTileentity
extends PiglinTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    protected NonNullList<ItemStack> outputInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    @Nullable
    protected NonNullList<ItemStack> itemsLeft;
    protected ItemStack barteringItem = ItemStack.EMPTY;
    protected int barteringTimeLeft;
    protected MultiItemStackHandler itemHandler = new MultiItemStackHandler(this.inputInventory, this.outputInventory, BarterSlot::isValid);
    protected ItemStackHandler outputHandler = new ItemStackHandler(this.outputInventory);

    public BartererTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BARTERER.get(), ((BartererBlock)((Object)ModBlocks.BARTERER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        Piglin p = this.getPiglinEntity();
        if (p == null) {
            return;
        }
        if (this.level.getGameTime() % 20L == 0L && this.level.random.nextInt(40) == 0) {
            BartererBlock.playPiglinSound(this.level, this.worldPosition, SoundEvents.PIGLIN_AMBIENT);
        }
        if (this.itemsLeft == null) {
            ItemStack oldBarteringItem = this.barteringItem;
            this.barteringItem = this.removeBarteringItem();
            if (!this.barteringItem.isEmpty()) {
                if (this.level.getRandom().nextInt(5) == 0) {
                    BartererBlock.playPiglinSound(this.level, this.getBlockPos(), SoundEvents.PIGLIN_ADMIRING_ITEM);
                }
                this.itemsLeft = this.generateLoot(p);
                this.barteringTimeLeft = 120;
                this.setChanged();
                this.sync();
            } else if (!oldBarteringItem.equals(this.barteringItem)) {
                this.sync();
            }
        }
        if (this.barteringTimeLeft <= 0) {
            this.insertItems();
        } else {
            --this.barteringTimeLeft;
            this.setChanged();
        }
    }

    public ItemStack removeBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.getCount() < 1) continue;
            return stack.split(1);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getRenderBarteringItem() {
        return this.barteringItem;
    }

    private NonNullList<ItemStack> generateLoot(Piglin piglin) {
        LootTable loottable = this.level.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.PIGLIN_BARTERING);
        ObjectArrayList loot = loottable.getRandomItems(new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)piglin).create(LootContextParamSets.PIGLIN_BARTER));
        return NonNullList.copyOf((Collection)loot);
    }

    private void insertItems() {
        if (this.itemsLeft == null) {
            return;
        }
        NonNullList newLeft = NonNullList.create();
        for (ItemStack drop : this.itemsLeft) {
            for (int i = 0; i < this.outputHandler.getSlots() && !(drop = this.outputHandler.insertItem(i, drop, false)).isEmpty(); ++i) {
            }
            if (drop.isEmpty()) continue;
            newLeft.add((Object)drop);
        }
        if (newLeft.isEmpty()) {
            this.itemsLeft = null;
            this.sync();
        } else {
            this.itemsLeft = newLeft;
        }
        this.setChanged();
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ItemUtils.saveInventory(valueOutput.child("InputInventory"), "Items", this.inputInventory);
        ItemUtils.saveInventory(valueOutput.child("OutputInventory"), "Items", this.outputInventory);
        if (this.itemsLeft != null) {
            ItemUtils.saveItemList(valueOutput, "ItemsLeft", this.itemsLeft);
        }
        if (!this.barteringItem.isEmpty()) {
            valueOutput.store("BarteringItem", ItemStack.CODEC, (Object)this.barteringItem);
        }
        valueOutput.putInt("BarteringTimeLeft", this.barteringTimeLeft);
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        this.inputInventory.clear();
        this.outputInventory.clear();
        ItemUtils.readItemList(valueInput.childOrEmpty("InputInventory"), "Items", this.inputInventory);
        ItemUtils.readItemList(valueInput.childOrEmpty("OutputInventory"), "Items", this.outputInventory);
        this.itemsLeft = ItemUtils.readItemList(valueInput, "ItemsLeft", false);
        this.barteringItem = valueInput.read("BarteringItem", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.barteringTimeLeft = valueInput.getIntOr("BarteringTimeLeft", 0);
        super.loadAdditional(valueInput);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((BartererTileentity)this).setChanged());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BartererTileentity)this).setChanged());
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

