/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.BartererTileentity;
import de.maxhenkel.easypiglins.corelib.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PiglinRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class BartererRenderer
implements BlockEntityRenderer<BartererTileentity> {
    private final Minecraft minecraft;
    protected EntityModelSet entityModelSet;
    private PiglinRenderer renderer;
    private PiglinRenderState piglinRenderState;

    public BartererRenderer(EntityModelSet entityModelSet) {
        this.entityModelSet = entityModelSet;
        this.minecraft = Minecraft.getInstance();
    }

    public void render(BartererTileentity barterer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn, Vec3 vec) {
        this.renderBlock(matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        this.renderWithoutBlock(barterer, partialTicks, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }

    public void renderWithoutBlock(BartererTileentity barterer, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Piglin piglin;
        matrixStack.pushPose();
        this.renderBlock(matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        Direction direction = Direction.SOUTH;
        if (!barterer.isFakeWorld()) {
            direction = (Direction)barterer.getBlockState().getValue((Property)BartererBlock.FACING);
        }
        if ((piglin = barterer.getPiglinEntity()) != null) {
            if (this.renderer == null) {
                this.renderer = (PiglinRenderer)this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)piglin);
            }
            if (this.piglinRenderState == null) {
                this.piglinRenderState = this.renderer.createRenderState();
            }
            piglin.setItemInHand(InteractionHand.OFF_HAND, barterer.getRenderBarteringItem());
            this.renderer.extractRenderState((AbstractPiglin)piglin, this.piglinRenderState, 0.0f);
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.0625, 0.5);
            matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-direction.toYRot()));
            matrixStack.translate(0.0, 0.0, -0.25);
            matrixStack.scale(0.45f, 0.45f, 0.45f);
            this.renderer.render((LivingEntityRenderState)this.piglinRenderState, matrixStack, buffer, combinedLightIn);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    protected void renderBlock(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state = ((BartererBlock)((Object)ModBlocks.BARTERER.get())).defaultBlockState();
        int color = this.minecraft.getBlockColors().getColor(state, null, null, 0);
        BlockRenderDispatcher dispatcher = this.minecraft.getBlockRenderer();
        dispatcher.getModelRenderer();
        ModelBlockRenderer.renderModel((PoseStack.Pose)matrixStack.last(), (MultiBufferSource)buffer, (BlockStateModel)dispatcher.getBlockModel(state), (float)RenderUtils.getRedFloat(color), (float)RenderUtils.getGreenFloat(color), (float)RenderUtils.getBlueFloat(color), (int)combinedLight, (int)combinedOverlay, (BlockAndTintGetter)this.minecraft.level, (BlockPos)BlockPos.ZERO, (BlockState)state);
    }
}

