/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseTall;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingLight
extends LightBaseTall {
    private static final VoxelShape TOP_MID = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape ONE = Block.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    private static final VoxelShape TWO = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
    private static final VoxelShape THREE = Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape BASE_BOTTOM = Shapes.or((VoxelShape)ONE, (VoxelShape[])new VoxelShape[]{TWO, THREE});

    public CeilingLight(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BOTTOM))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected BlockState LightState(BlockState state, LevelReader level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        Boolean lit = (Boolean)state.getValue((Property)LIT);
        if (lit.booleanValue()) {
            if (above && below) {
                return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.MIDDLE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            }
            if (!above && below) {
                return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.TOP))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            }
            if (above && !below) {
                return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BOTTOM))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BASE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        if (above && below) {
            return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.MIDDLE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (!above && below) {
            return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.TOP))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (above && !below) {
            return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BOTTOM))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)((Object)LightBaseTall.LightPart.BASE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        LightBaseTall.LightPart part = (LightBaseTall.LightPart)((Object)state.getValue((Property)PART));
        Item item = itemstack.getItem();
        if (item != this.asItem()) {
            if (!worldIn.isClientSide() && part == LightBaseTall.LightPart.TOP || part == LightBaseTall.LightPart.MIDDLE) {
                return InteractionResult.PASS;
            }
            if (part == LightBaseTall.LightPart.BOTTOM || part == LightBaseTall.LightPart.BASE) {
                state = (BlockState)state.cycle((Property)LIT);
                worldIn.setBlock(pos, state, 10);
                worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((LightBaseTall.LightPart)((Object)state.getValue((Property)PART))) {
            case BASE: {
                return BASE_BOTTOM;
            }
            case TOP: {
                return TOP_MID;
            }
            case MIDDLE: {
                return TOP_MID;
            }
            case BOTTOM: {
                return BASE_BOTTOM;
            }
        }
        return BASE_BOTTOM;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, LIT, POWERED});
    }
}

