/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects.candles;

import com.mcwlights.kikoz.objects.candles.WallCandle;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DoubleCandle
extends WallCandle {
    private static final VoxelShape NS = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape WE = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)16.0);

    public DoubleCandle(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NS;
            }
            case SOUTH: {
                return NS;
            }
            case EAST: {
                return WE;
            }
        }
        return WE;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public void animateTick(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 1.0;
        double d2 = (double)pos.getZ() + 0.5;
        double d3 = (double)pos.getZ() + 0.5;
        double d4 = (double)pos.getX() + 0.5;
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                d0 += 0.3;
                d4 -= 0.3;
                break;
            }
            case SOUTH: {
                d0 += 0.3;
                d4 -= 0.3;
                break;
            }
            case EAST: {
                d2 += 0.3;
                d3 -= 0.3;
                break;
            }
            case WEST: {
                d2 += 0.3;
                d3 -= 0.3;
                break;
            }
        }
        Boolean i = (Boolean)state.getValue((Property)LIT);
        if (i.booleanValue()) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d4, d1, d3, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d4, d1, d3, 0.0, 0.0, 0.0);
        }
    }
}

