/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.client.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlockStateTranslator {
    public static final BlockStateTranslator INSTANCE = new BlockStateTranslator();

    public Map<BlockState, BlockState> convertAllBlockStates(Block newBlock, Block oldBlock) {
        return (Map)newBlock.getStateDefinition().getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), blockState -> this.convertBlockState((StateDefinition<Block, BlockState>)oldBlock.getStateDefinition(), (BlockState)blockState)));
    }

    private BlockState convertBlockState(StateDefinition<Block, BlockState> newStateDefinition, BlockState oldBlockState) {
        BlockState newBlockState = (BlockState)newStateDefinition.any();
        for (Map.Entry entry : oldBlockState.getValues().entrySet()) {
            newBlockState = this.setBlockStateValue((Property)entry.getKey(), (Comparable)entry.getValue(), arg_0 -> newStateDefinition.getProperty(arg_0), newBlockState);
        }
        return newBlockState;
    }

    private <T extends Comparable<T>, V extends T> BlockState setBlockStateValue(Property<?> oldProperty, Comparable<?> oldValue, Function<String, @Nullable Property<?>> propertyGetter, BlockState blockState) {
        Property<?> newProperty = propertyGetter.apply(oldProperty.getName());
        if (newProperty != null) {
            Comparable<?> newValue = this.getNewPropertyValue(oldProperty, newProperty, oldValue);
            return (BlockState)blockState.setValue(newProperty, newValue);
        }
        return blockState;
    }

    protected Comparable<?> getNewPropertyValue(Property<?> oldProperty, Property<?> newProperty, Comparable<?> oldValue) {
        return oldValue;
    }
}

