/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChunkLoaderBlock
extends BaseBlock
implements EntityHoldingBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BlockShape SINGLE_SHAPE = BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final BlockShape BASIC_SHAPE = BlockShape.createBlockShape((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BlockShape ADVANCED_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final BlockShape ULTIMATE_SHAPE = BlockShape.createBlockShape((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    private final ChunkLoaderType type;

    public ChunkLoaderBlock(ChunkLoaderType type) {
        super(false, BlockProperties.create().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).requiresCorrectTool().destroyTime(1.5f).explosionResistance(6.0f));
        this.type = type;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof ChunkLoaderBlockEntity) {
            if (((ChunkLoaderBlockEntity)entity).hasOwner()) {
                if (level.isClientSide) {
                    ChunkLoadersClient.openChunkLoaderScreen((ChunkLoaderBlockEntity)entity);
                }
            } else if (player.isShiftKeyDown()) {
                if (level.isClientSide) {
                    player.displayClientMessage((Component)TextComponents.translation((String)"chunkloaders.legacy_success").color(ChatFormatting.WHITE).get(), true);
                } else {
                    ((ChunkLoaderBlockEntity)entity).setOwner(player.getUUID());
                }
            } else if (level.isClientSide) {
                player.displayClientMessage((Component)TextComponents.translation((String)"chunkloaders.legacy_message").color(ChatFormatting.RED).get(), true);
            }
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.type.getShape().getUnderlying();
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return this.type.createBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof ChunkLoaderBlockEntity && placer instanceof Player) {
            ((ChunkLoaderBlockEntity)entity).setOwner(placer.getUUID());
        }
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity entity;
        if (newState.is((Block)this) && (entity = level.getBlockEntity(pos)) instanceof ChunkLoaderBlockEntity) {
            entity.onLoad();
        }
    }

    public void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
        if (this.type.getGridSize() == 1) {
            info.accept((Component)TextComponents.translation((String)"chunkloaders.chunk_loader.info.single").color(ChatFormatting.AQUA).get());
        } else {
            info.accept((Component)TextComponents.translation((String)"chunkloaders.chunk_loader.info.multiple", (Object[])new Object[]{this.type.getGridSize()}).color(ChatFormatting.AQUA).get());
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, random);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }
}

