/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ChunkLoaderBlockEntityRenderer
implements CustomBlockEntityRenderer<ChunkLoaderBlockEntity> {
    private final Block block;
    private final boolean fullRotation;

    public ChunkLoaderBlockEntityRenderer(Block block, boolean fullRotation) {
        this.block = block;
        this.fullRotation = fullRotation;
    }

    public void render(ChunkLoaderBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.pushPose();
        double offset = Math.sin((double)((float)((System.currentTimeMillis() + (long)entity.animationOffset) % 5000L) / 5000.0f * 2.0f) * Math.PI) * 0.1;
        poseStack.translate(0.0, offset, 0.0);
        poseStack.translate(0.5, 0.5, 0.5);
        if (this.fullRotation) {
            float angleX = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 13000L) / 13000.0f * 2.0f * (float)Math.PI;
            float angleY = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 15000L) / 15000.0f * 2.0f * (float)Math.PI;
            float angleZ = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 16000L) / 16000.0f * 2.0f * (float)Math.PI;
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(angleX, 1.0f, 0.0f, 0.0f));
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(angleY, 0.0f, 1.0f, 0.0f));
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(angleZ, 0.0f, 0.0f, 1.0f));
        } else {
            float angle = (float)((System.currentTimeMillis() + (long)entity.animationOffset) % 11000L) / 11000.0f * 2.0f * (float)Math.PI;
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(angle, 0.0f, 1.0f, 0.0f));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        BlockRenderDispatcher blockRenderer = ClientUtils.getBlockRenderer();
        BlockStateModel model = blockRenderer.getBlockModel(this.block.defaultBlockState());
        ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (MultiBufferSource)bufferSource, (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)combinedLight, (int)combinedOverlay, (BlockAndTintGetter)entity.getLevel(), (BlockPos)entity.getBlockPos(), (BlockState)this.block.defaultBlockState());
        poseStack.popPose();
    }
}

