/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntityRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(value={Dist.CLIENT})
public class ChunkLoadersClient {
    private static KeyMapping CHUNK_LOADING_SCREEN_KEY;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, () -> new ChunkLoaderBlockEntityRenderer((Block)type.getBlock(), type.getFullRotation()));
        }
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent e) {
        CHUNK_LOADING_SCREEN_KEY = new KeyMapping("chunkloaders.keys.open_screen", 67, "chunkloaders.keys.category");
        e.register(CHUNK_LOADING_SCREEN_KEY);
        NeoForge.EVENT_BUS.addListener(ChunkLoadersClient::onKey);
    }

    public static void onKey(InputEvent.Key e) {
        if (CHUNK_LOADING_SCREEN_KEY != null && CHUNK_LOADING_SCREEN_KEY.matches(e.getKey(), e.getScanCode()) && ClientUtils.getWorld() != null && ClientUtils.getMinecraft().screen == null) {
            Player player = ClientUtils.getPlayer();
            if (ChunkLoadersConfig.canPlayersUseMap.get().booleanValue()) {
                ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(player.blockPosition()), player.getUUID(), player.blockPosition().getY(), 15, 11)));
            } else {
                player.displayClientMessage((Component)TextComponents.translation((String)"chunkloaders.gui.disabled").color(ChatFormatting.RED).get(), true);
            }
        }
    }

    public static void openChunkLoaderScreen(ChunkLoaderBlockEntity entity) {
        int size = entity.getChunkLoaderType().getGridSize() + 2;
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(entity.getBlockPos()), entity.getOwner(), entity.getBlockPos().getY(), size, size)));
    }
}

