/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class ChunkLoadingCapabilitySaveData
extends SavedData {
    private static final String IDENTIFIER = "chunkloaders_loaded_chunks";
    private final ChunkLoadingCapability capability;

    public static void init(ServerLevel level, final ChunkLoadingCapability capability) {
        level.getDataStorage().computeIfAbsent(new SavedDataType(IDENTIFIER, () -> new ChunkLoadingCapabilitySaveData(capability), (Codec)new Codec<ChunkLoadingCapabilitySaveData>(){

            public <T> DataResult<Pair<ChunkLoadingCapabilitySaveData, T>> decode(DynamicOps<T> ops, T input) {
                try {
                    ChunkLoadingCapabilitySaveData saveData = new ChunkLoadingCapabilitySaveData(capability);
                    saveData.load((CompoundTag)ops.convertTo((DynamicOps)NbtOps.INSTANCE, input));
                    return DataResult.success((Object)Pair.of((Object)((Object)saveData), input));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }

            public <T> DataResult<T> encode(ChunkLoadingCapabilitySaveData input, DynamicOps<T> ops, T prefix) {
                try {
                    return DataResult.success((Object)NbtOps.INSTANCE.convertTo(ops, (Tag)input.save()));
                }
                catch (Exception e) {
                    return DataResult.error(e::getMessage);
                }
            }
        }));
    }

    public ChunkLoadingCapabilitySaveData(ChunkLoadingCapability capability) {
        this.capability = capability;
    }

    public CompoundTag save() {
        return this.capability.write();
    }

    public void load(CompoundTag tag) {
        this.capability.read(tag);
    }

    public boolean isDirty() {
        return true;
    }
}

