/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LanternBlock
extends net.minecraft.world.level.block.LanternBlock {
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    public static final BooleanProperty REDSTONE = BooleanProperty.create((String)"redstone");
    public final LanternMaterial material;
    public final LanternColor color;

    public LanternBlock(LanternMaterial material, LanternColor color) {
        super(material.getLanternBlockProperties(color));
        this.material = material;
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(true))).setValue((Property)REDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.material.canBeColored && stack.getItem() instanceof DyeItem) {
            LanternColor color = LanternColor.fromDyeColor(((DyeItem)stack.getItem()).getDyeColor());
            BlockState newState = this.material.getLanternBlock(color).defaultBlockState();
            newState = (BlockState)newState.setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
            newState = (BlockState)newState.setValue((Property)HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)));
            newState = (BlockState)newState.setValue((Property)ON, (Comparable)((Boolean)state.getValue((Property)ON)));
            newState = (BlockState)newState.setValue((Property)REDSTONE, (Comparable)((Boolean)state.getValue((Property)REDSTONE)));
            level.setBlock(pos, newState, 3);
        } else if (this.material == LanternMaterial.NORMAL && this.color == null && !((Boolean)state.getValue((Property)ON)).booleanValue() && !((Boolean)state.getValue((Property)REDSTONE)).booleanValue()) {
            level.setBlock(pos, (BlockState)((BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)ON) == false)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ON, REDSTONE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        boolean redstone = context.getLevel().hasNeighborSignal(context.getClickedPos());
        if (!redstone && this.material == LanternMaterial.NORMAL && this.color == null) {
            return (BlockState)((BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
        }
        return (BlockState)state.setValue((Property)REDSTONE, (Comparable)Boolean.valueOf(redstone));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        if (!level.isClientSide) {
            boolean redstone = level.hasNeighborSignal(pos);
            if (this.material == LanternMaterial.NORMAL && this.color == null && ((Boolean)state.getValue((Property)ON)).booleanValue() && !redstone) {
                level.setBlock(pos, (BlockState)((BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)((Boolean)state.getValue((Property)HANGING)))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))), 7);
            } else if ((Boolean)state.getValue((Property)REDSTONE) != redstone) {
                level.setBlock(pos, (BlockState)state.setValue((Property)REDSTONE, (Comparable)Boolean.valueOf(redstone)), 7);
            }
        }
    }

    public static boolean emitsLight(BlockState state) {
        return state.getValue((Property)REDSTONE) != state.getValue((Property)ON);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        if (this.material == LanternMaterial.NORMAL && this.color == null) {
            return new ItemStack((ItemLike)Blocks.LANTERN);
        }
        return super.getCloneItemStack(level, pos, state, includeData, player);
    }
}

