/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityMechanicalDryingBasin;
import org.cyclops.integrateddynamics.core.block.BlockMechanicalMachine;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;

public class BlockMechanicalDryingBasin
extends BlockMechanicalMachine {
    public static final MapCodec<BlockMechanicalDryingBasin> CODEC = BlockMechanicalDryingBasin.simpleCodec(BlockMechanicalDryingBasin::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public BlockMechanicalDryingBasin(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityMechanicalDryingBasin::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockMechanicalDryingBasin.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MECHANICAL_DRYING_BASIN.get()), new BlockEntityMechanicalMachine.Ticker());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT});
    }

    public InteractionResult useWithoutItem(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult rayTraceResult) {
        if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)player.getUsedItemHand(), (Level)world, (BlockPos)blockPos, (Direction)Direction.UP) || FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)player.getUsedItemHand(), (Level)world, (BlockPos)blockPos, (Direction)Direction.DOWN)) {
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, world, blockPos, player, rayTraceResult);
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockPos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, blockPos, BlockEntityMechanicalDryingBasin.class).ifPresent(tile -> {
                if (itemStack.has(RegistryEntries.DATACOMPONENT_FLUID_CONTENT_IN_OUT)) {
                    Pair tanks = (Pair)itemStack.get(RegistryEntries.DATACOMPONENT_FLUID_CONTENT_IN_OUT);
                    tile.getTankInput().setFluid(((SimpleFluidContent)tanks.getLeft()).copy());
                    tile.getTankOutput().setFluid(((SimpleFluidContent)tanks.getLeft()).copy());
                }
            });
        }
        super.setPlacedBy(world, blockPos, state, placer, itemStack);
    }

    @Override
    protected boolean isPickBlockPersistData() {
        return true;
    }
}

