/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.item.ItemFacade;

public class VoxelShapeComponentsFactoryHandlerFacade
implements VoxelShapeComponentsFactory.IHandler {
    private static final VoxelShape BOUNDS = Shapes.create((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    private static final Component COMPONENT = new Component();

    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        ILevelExtension level;
        if (world instanceof ILevelExtension && CableHelpers.hasFacade(level = (ILevelExtension)world, blockPos, blockState)) {
            return Collections.singletonList(COMPONENT);
        }
        return Collections.emptyList();
    }

    public static class Component
    implements VoxelShapeComponents.IComponent {
        @Override
        public String getStateId(BlockState blockState, BlockGetter world, BlockPos blockPos) {
            Object id = "fac";
            Optional<BlockState> optionalFacade = CableHelpers.getFacade((ILevelExtension)((Level)world), blockPos, blockState);
            if (optionalFacade.isPresent()) {
                id = (String)id + "(" + optionalFacade.get().toString() + ")";
            }
            return id;
        }

        @Override
        public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
            return BOUNDS;
        }

        @Override
        public ItemStack getCloneItemStack(Level world, BlockPos pos) {
            ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_FACADE);
            CableHelpers.getFacade((ILevelExtension)world, pos, world.getBlockState(pos)).ifPresent(facade -> ((ItemFacade)((Object)((Object)RegistryEntries.ITEM_FACADE.get()))).writeFacadeBlock(itemStack, (BlockState)facade));
            return itemStack;
        }

        @Override
        public boolean destroy(Level world, BlockPos pos, Player player, boolean saveState) {
            if (!world.isClientSide()) {
                IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, Capabilities.Facadeable.BLOCK).ifPresent(facadeable -> {
                    BlockState blockState = facadeable.getFacade();
                    ItemStack itemStack = new ItemStack(RegistryEntries.ITEM_FACADE);
                    ((ItemFacade)((Object)((Object)RegistryEntries.ITEM_FACADE.get()))).writeFacadeBlock(itemStack, blockState);
                    facadeable.setFacade(null);
                    if (!player.isCreative()) {
                        IModHelpers.get().getItemStackHelpers().spawnItemStackToPlayer(world, pos, itemStack, player);
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.getItemInHand(hand);
            if (WrenchHelpers.isWrench(player, heldItem, world, blockPos, hit.getDirection()) && player.isSecondaryUseActive()) {
                if (!world.isClientSide()) {
                    this.destroy(world, blockPos, player, true);
                    world.updateNeighborsAt(blockPos, state.getBlock());
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }

        @Override
        @Nullable
        public Direction getRaytraceDirection() {
            return null;
        }

        @Override
        public boolean isRaytraceLastForFace() {
            return true;
        }
    }
}

