/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockSqueezer;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class BlockEntitySqueezer
extends CyclopsBlockEntity {
    private final SimpleInventory inventory = new SimpleInventory(1, 1){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            return (Integer)BlockEntitySqueezer.this.getLevel().getBlockState(BlockEntitySqueezer.this.getBlockPos()).getValue((Property)BlockSqueezer.HEIGHT) == 1 && this.getItem(0).isEmpty() && super.canPlaceItem(slot, itemStack);
        }

        public void setItem(int slotId, ItemStack itemstack) {
            super.setItem(slotId, itemstack);
            BlockEntitySqueezer.this.itemHeight = 1;
            BlockEntitySqueezer.this.sendUpdate();
        }
    };
    private final SingleUseTank tank = new SingleUseTank(IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume());
    @NBTPersist
    private int itemHeight = 1;
    private SingleCache<ItemStack, Optional<RecipeHolder<RecipeSqueezer>>> recipeCache;

    public BlockEntitySqueezer(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_SQUEEZER.get(), blockPos, blockState);
        this.inventory.addDirtyMarkListener(() -> ((BlockEntitySqueezer)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).setChanged());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeHolder<RecipeSqueezer>>>(){

            public Optional<RecipeHolder<RecipeSqueezer>> getNewValue(ItemStack key) {
                return IModHelpers.get().getCraftingHelpers().findRecipe(BlockEntitySqueezer.this.getRegistry(), (RecipeInput)CraftingInput.of((int)1, (int)1, (List)Lists.newArrayList((Object[])new ItemStack[]{key})), BlockEntitySqueezer.this.getLevel());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.matches((ItemStack)cacheKey, (ItemStack)newKey);
            }
        });
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(ValueInput input) {
        this.inventory.readFromNBT(input, "inventory");
        this.tank.deserialize(input, "tank");
        super.read(input);
    }

    public void saveAdditional(ValueOutput output) {
        this.inventory.writeToNBT(output, "inventory");
        this.tank.serialize(output, "tank");
        super.saveAdditional(output);
    }

    protected RecipeType<RecipeSqueezer> getRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get();
    }

    public Optional<RecipeHolder<RecipeSqueezer>> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)this.getInventory().getItem(0).copy());
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
        this.sendUpdate();
        this.getInventory().setChanged();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.getInventory());
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntitySqueezer> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntitySqueezer blockEntity) {
            Optional<RecipeHolder<RecipeSqueezer>> recipeOptional;
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (!blockEntity.getTank().isEmpty()) {
                Direction.Axis axis = (Direction.Axis)blockState.getValue(BlockSqueezer.AXIS);
                Arrays.stream(Direction.AxisDirection.values()).map(axisDirection -> Direction.get((Direction.AxisDirection)axisDirection, (Direction.Axis)axis)).forEach(side -> {
                    if (!blockEntity.getTank().isEmpty()) {
                        IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(side), (Object)side.getOpposite(), Capabilities.FluidHandler.BLOCK).ifPresent(handler -> {
                            FluidStack fluidStack = new FluidStack(blockEntity.getTank().getFluid().getFluid(), Math.min(100, blockEntity.getTank().getFluidAmount()));
                            if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                                int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                                blockEntity.getTank().drain(filled, IFluidHandler.FluidAction.EXECUTE);
                            }
                        });
                    }
                });
            } else if (blockEntity.itemHeight == 7 && (recipeOptional = blockEntity.getCurrentRecipe()).isPresent()) {
                RecipeSqueezer recipe = (RecipeSqueezer)recipeOptional.get().value();
                blockEntity.getInventory().setItem(0, ItemStack.EMPTY);
                for (RecipeSqueezer.IngredientChance itemStackChance : recipe.getOutputItems()) {
                    if (itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= level.random.nextFloat())) continue;
                    ItemStack resultStack = itemStackChance.getIngredientFirst().copy();
                    for (Direction side2 : Direction.values()) {
                        IItemHandler itemHandler;
                        if (resultStack.isEmpty() || side2 == Direction.UP || (itemHandler = (IItemHandler)IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)level, pos.relative(side2), (Object)side2.getOpposite(), Capabilities.ItemHandler.BLOCK).orElse(null)) == null) continue;
                        resultStack = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)resultStack, (boolean)false);
                    }
                    if (resultStack.isEmpty()) continue;
                    IModHelpers.get().getItemStackHelpers().spawnItemStack(level, pos, resultStack);
                }
                if (recipe.getOutputFluid().isPresent()) {
                    blockEntity.getTank().fill(recipe.getOutputFluid().get(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntitySqueezer> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntitySqueezer>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> new InvWrapper((Container)blockEntity.getInventory()));
            this.add(Capabilities.InventoryState.BLOCK, (blockEntity, direction) -> new SimpleInventoryState(blockEntity.getInventory()));
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
            this.add(Capabilities.RecipeHandler.BLOCK, (blockEntity, direction) -> new RecipeHandlerSqueezer(() -> ((BlockEntitySqueezer)((Object)blockEntity)).getLevel(), (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get()));
        }
    }
}

