/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.variablecontainer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class VariableContainerDefault
implements IVariableContainer {
    private final Map<Integer, IVariableFacade> variableCache = Maps.newHashMap();

    @Override
    public Map<Integer, IVariableFacade> getVariableCache() {
        return this.variableCache;
    }

    @Override
    public void refreshVariables(INetwork network, Container inventory, boolean sendVariablesUpdateEvent, ValueDeseralizationContext valueDeseralizationContext) {
        NetworkHelpers.getPartNetwork(network).ifPresent(partNetwork -> {
            for (IVariableFacade variableFacade : this.getVariableCache().values()) {
                IVariable variable = variableFacade.getVariable(network, (IPartNetwork)partNetwork);
                if (variable == null) continue;
                variable.invalidate();
            }
        });
        this.getVariableCache().clear();
        IVariableFacade firstInvalidVariableFacade = null;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            IVariableFacade variableFacade;
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack.isEmpty() || (variableFacade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(valueDeseralizationContext, itemStack)) == null) continue;
            if (variableFacade.isValid()) {
                this.getVariableCache().put(variableFacade.getId(), variableFacade);
                continue;
            }
            if (firstInvalidVariableFacade != null) continue;
            firstInvalidVariableFacade = variableFacade;
        }
        if (this.getVariableCache().isEmpty() && firstInvalidVariableFacade != null) {
            this.getVariableCache().put(firstInvalidVariableFacade.getId(), firstInvalidVariableFacade);
        }
        if (sendVariablesUpdateEvent && network != null) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }
}

