/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.gui.container;

import com.google.common.collect.Lists;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenMultipart;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;
import org.cyclops.integrateddynamics.inventory.container.ContainerPartPanelVariableDriven;

public class ContainerScreenPartDisplay<P extends PartTypePanelVariableDriven<P, S>, S extends PartTypePanelVariableDriven.State<P, S>>
extends ContainerScreenMultipart<P, S, ContainerPartPanelVariableDriven<P, S>> {
    private static final int ERROR_X = 104;
    private static final int ERROR_Y = 16;
    private static final int OK_X = 104;
    private static final int OK_Y = 16;

    public ContainerScreenPartDisplay(ContainerPartPanelVariableDriven<P, S> container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    @Override
    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonText(this.getGuiLeftTotal() + 128, this.getGuiTopTotal() + 32, 30, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.copy"), (Component)Component.translatable((String)"gui.integrateddynamics.button.copy"), button -> this.valueToClipboard(), true));
    }

    @Override
    protected String getNameId() {
        return "part_display";
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        Component readValue = ((ContainerPartPanelVariableDriven)this.getMenu()).getReadValue();
        int readValueColor = ((ContainerPartPanelVariableDriven)this.getMenu()).getReadValueColor();
        boolean ok = false;
        if (readValue != null) {
            ok = true;
            IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.font, readValue.getString(), this.getGuiLeftTotal() + 53, this.getGuiTopTotal() + 38, 70, ARGB.opaque((int)readValueColor), false, Font.DisplayMode.NORMAL);
        }
        this.displayErrors.drawBackground(guiGraphics, ((ContainerPartPanelVariableDriven)this.getMenu()).getReadErrors(), 104, 16, 104, 16, this, this.leftPos, this.topPos, ok);
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.displayErrors.drawForeground(guiGraphics, ((ContainerPartPanelVariableDriven)this.getMenu()).getReadErrors(), 104, 16, mouseX, mouseY, this, this.leftPos, this.topPos);
        IModHelpers.get().getGuiHelpers().renderTooltip((AbstractContainerScreen)this, guiGraphics, 128, 32, 30, 12, mouseX, mouseY, () -> Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.button.copy.info")}));
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (67 == keyCode && KeyModifier.CONTROL.isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            this.valueToClipboard();
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 128;
    }

    protected void valueToClipboard() {
        Component readValue = ((ContainerPartPanelVariableDriven)this.getMenu()).getReadValue();
        if (readValue != null) {
            this.getMinecraft().keyboardHandler.setClipboard(readValue.getString());
        }
    }
}

