/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.model.CableModelBase;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.jetbrains.annotations.Nullable;

public class CableModel
extends CableModelBase {
    public CableModel(BlockAndTintGetter level, BlockState state, Direction facing, RandomSource rand, ModelData modelData, ChunkSectionLayer renderType) {
        super(level, state, facing, rand, modelData, renderType);
    }

    public CableModel(ItemStack itemStack, Level world, LivingEntity entity) {
        super(itemStack, world, entity);
    }

    public CableModel() {
    }

    @Override
    protected boolean isRealCable(ModelData modelData) {
        return (Boolean)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.REALCABLE, (Object)true);
    }

    @Override
    protected Optional<BlockState> getFacade(ModelData modelData) {
        return (Optional)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.FACADE, Optional.empty());
    }

    @Override
    protected boolean isConnected(ModelData modelData, Direction side) {
        return (Boolean)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.CONNECTED[side.ordinal()], (Object)false);
    }

    @Override
    protected boolean hasPart(ModelData modelData, Direction side) {
        return this.getPartRenderPosition(modelData, side) != PartRenderPosition.NONE;
    }

    @Override
    protected PartRenderPosition getPartRenderPosition(ModelData modelData, Direction side) {
        return (PartRenderPosition)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)PartRenderPosition.NONE);
    }

    @Override
    protected boolean shouldRenderParts(ModelData modelData) {
        return ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.PARTCONTAINER, null) != null;
    }

    @Override
    protected BlockStateModel getPartModel(ModelData modelData, Direction side) {
        IPartContainer partContainer = (IPartContainer)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.PARTCONTAINER, null);
        BlockState blockState = partContainer != null && partContainer.hasPart(side) ? partContainer.getPart(side).getBlockState(partContainer, side) : null;
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRendererDispatcher = mc.getBlockRenderer();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.getBlockModelShaper();
        return blockModelShapes.getBlockModel(blockState);
    }

    @Override
    protected IRenderState getRenderState(ModelData modelData) {
        return (IRenderState)ModelHelpers.getSafeProperty((ModelData)modelData, BlockCable.RENDERSTATE, null);
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        return new CableModel(level, state, side, rand, extraData, renderType).getGeneralQuads();
    }

    public List<BakedQuad> handleItemState(@Nullable ItemStack stack, @Nullable Level world, @Nullable LivingEntity entity) {
        return new CableModel(stack, world, entity).getGeneralQuads();
    }

    public UnbakedModel wrapped() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ResolvedModel parent() {
        throw new UnsupportedOperationException();
    }

    public String debugName() {
        return "integrateddynamics:CableModel";
    }
}

