/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.mojang.math.Quadrant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.model.data.ModelData;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCableClientConfig;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class CableModelBase
extends DelegatingDynamicItemAndBlockModel {
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    private static final Cache<Triple<IRenderState, Direction, ChunkSectionLayer>, List<BakedQuad>> CACHE_QUADS = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private static final int RADIUS = 4;
    private static final int TEXTURE_SIZE = 16;
    private static final int LENGTH_CONNECTION = 6;
    private static final int LENGTH_CONNECTION_LIMITED = 1;
    private static final int INV_LENGTH_CONNECTION = 10;
    public static final float MIN = 0.375f;
    public static final float MAX = 0.625f;
    private static final PartRenderPosition CABLE_RENDERPOSITION = new PartRenderPosition(-1.0f, 0.375f, 0.25f, 0.25f);
    private final float[][][] quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f);
    protected static final ItemTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(0.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.03125f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f)), (Object)ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (Object)new ItemTransform((Vector3fc)new Vector3f(0.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.03125f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f))));

    public CableModelBase(BlockAndTintGetter level, BlockState blockState, Direction facing, RandomSource rand, ModelData modelData, ChunkSectionLayer renderType) {
        super(level, blockState, facing, rand, modelData, renderType);
    }

    public CableModelBase(ItemStack itemStack, Level world, LivingEntity entity) {
        super(itemStack, world, entity);
    }

    public CableModelBase() {
    }

    protected static float[][][] makeQuadVertexes(float min, float max, float length) {
        return new float[][][]{new float[][]{{min, length, min}, {max, length, min}, {max, max, min}, {min, max, min}}, new float[][]{{min, max, min}, {min, max, max}, {min, length, max}, {min, length, min}}, new float[][]{{min, max, max}, {max, max, max}, {max, length, max}, {min, length, max}}, new float[][]{{max, length, min}, {max, length, max}, {max, max, max}, {max, max, min}}};
    }

    private Direction getSideFromVecs(Vec3 a, Vec3 b, Vec3 c) {
        int dir;
        int n = a.y == b.y && b.y == c.y ? 0 : (dir = a.x == b.x && b.x == c.x ? 2 : 4);
        if (dir == 0) {
            dir += c.y >= 0.5 ? 1 : 0;
        } else if (dir == 2) {
            dir += c.x >= 0.5 ? 1 : 0;
        } else if (dir == 4) {
            dir += c.z >= 0.5 ? 1 : 0;
        }
        return Direction.from3DDataValue((int)dir);
    }

    public List<BakedQuad> getFacadeQuads(BlockStateModel facadeModel, BlockState blockState, Direction side, PartRenderPosition partRenderPosition, ChunkSectionLayer renderType) {
        ArrayList originalQuads = Lists.newArrayList();
        for (BlockModelPart collectPart : facadeModel.collectParts(this.level, BlockPos.ZERO, blockState, this.rand)) {
            if (collectPart.getRenderType(blockState) != renderType) continue;
            originalQuads.addAll(collectPart.getQuads(null));
            for (Direction direction : Direction.values()) {
                originalQuads.addAll(collectPart.getQuads(direction));
            }
        }
        return originalQuads.stream().flatMap(originalQuad -> {
            LinkedList ret = Lists.newLinkedList();
            if (partRenderPosition == PartRenderPosition.NONE) {
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, 0.0f, 0.0f, 1.0f, 1.0f, side);
            } else {
                float w = partRenderPosition.getWidthFactorSide();
                float h = partRenderPosition.getHeightFactorSide();
                float u0 = 0.0f;
                float v0 = 0.0f;
                float u1 = (1.0f - w) / 2.0f;
                float v1 = (1.0f - h) / 2.0f;
                float u2 = u1 + w;
                float v2 = v1 + h;
                float u3 = 1.0f;
                float v3 = 1.0f;
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v0, u1, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u1, v0, u2, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v0, u3, v1, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v1, u1, v2, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v1, u3, v2, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u0, v2, u1, v3, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u1, v2, u2, v3, side);
                this.addFacadeQuad(ret, (BakedQuad)originalQuad, u2, v2, u3, v3, side);
            }
            return ret.stream();
        }).collect(Collectors.toList());
    }

    private void addFacadeQuad(List<BakedQuad> quads, BakedQuad originalQuad, float u0, float v0, float u1, float v1, Direction side) {
        Vector3f from = new Vector3f(u0 * 16.0f, v0 * 16.0f, 0.0f);
        Vector3f to = new Vector3f(u1 * 16.0f, v1 * 16.0f, 0.0f);
        TextureAtlasSprite texture = originalQuad.sprite();
        BlockElementFace.UVs blockFaceUV = new BlockElementFace.UVs(16.0f - u1 * 16.0f, 16.0f - v1 * 16.0f, 16.0f - u0 * 16.0f, 16.0f - v0 * 16.0f);
        Direction NO_FACE_CULLING = null;
        String DUMMY_TEXTURE_NAME = "";
        BlockElementFace blockPartFace = new BlockElementFace(NO_FACE_CULLING, originalQuad.tintIndex(), DUMMY_TEXTURE_NAME, blockFaceUV, Quadrant.R0);
        BlockModelRotation transformation = CableModelBase.getRotation(side);
        BlockElementRotation DEFAULT_ROTATION = null;
        boolean APPLY_SHADING = true;
        quads.add(FaceBakery.bakeQuad((Vector3fc)from, (Vector3fc)to, (BlockElementFace)blockPartFace, (TextureAtlasSprite)texture, (Direction)Direction.NORTH, (ModelState)transformation, DEFAULT_ROTATION, (boolean)APPLY_SHADING, (int)0));
    }

    public static BlockModelRotation getRotation(Direction facing) {
        switch (facing) {
            case DOWN: {
                return BlockModelRotation.X90_Y180;
            }
            case UP: {
                return BlockModelRotation.X270_Y180;
            }
            case NORTH: {
                return BlockModelRotation.X0_Y0;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: {
                return BlockModelRotation.X0_Y270;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
        }
        throw new IllegalArgumentException(String.valueOf(facing));
    }

    protected abstract boolean isRealCable(ModelData var1);

    protected abstract Optional<BlockState> getFacade(ModelData var1);

    protected abstract boolean isConnected(ModelData var1, Direction var2);

    protected abstract boolean hasPart(ModelData var1, Direction var2);

    protected abstract PartRenderPosition getPartRenderPosition(ModelData var1, Direction var2);

    protected abstract boolean shouldRenderParts(ModelData var1);

    protected abstract BlockStateModel getPartModel(ModelData var1, Direction var2);

    protected abstract IRenderState getRenderState(ModelData var1);

    public List<BakedQuad> getGeneralQuads() {
        IRenderState renderState;
        Triple cacheKey = null;
        List cachedQuads = null;
        if (GeneralConfig.cacheCableModels && (renderState = this.getRenderState(this.modelData)) != null) {
            cacheKey = Triple.of((Object)renderState, (Object)this.facing, (Object)this.renderType);
            cachedQuads = (List)CACHE_QUADS.getIfPresent((Object)cacheKey);
        }
        if (cachedQuads == null) {
            LinkedList ret = Lists.newLinkedList();
            TextureAtlasSprite texture = this.particleIcon();
            Optional<BlockState> blockStateHolder = this.getFacade(this.modelData);
            boolean renderCable = this.isItemStack() || this.isRealCable(this.modelData) && (!blockStateHolder.isPresent() && this.renderType == ChunkSectionLayer.SOLID || blockStateHolder.isPresent() && this.renderType == ChunkSectionLayer.TRANSLUCENT);
            for (Direction side : Direction.values()) {
                boolean hasPart;
                boolean isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                if (hasPart && this.shouldRenderParts(this.modelData)) {
                    try {
                        for (BlockModelPart collectPart : this.getPartModel(this.modelData, side).collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
                            ret.addAll(collectPart.getQuads(null));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!renderCable) continue;
                if (isConnected || hasPart) {
                    int i = 0;
                    float[][][] quadVertexes = this.quadVertexes;
                    if (hasPart) {
                        PartRenderPosition partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                        float depthFactor = partRenderPosition == PartRenderPosition.NONE ? 0.0f : partRenderPosition.getDepthFactor();
                        quadVertexes = CableModelBase.makeQuadVertexes(0.375f, 0.625f, 1.0f - depthFactor);
                    }
                    for (float[][] v : quadVertexes) {
                        Vec3 v1 = CableModelBase.rotate((Vec3)new Vec3((double)v[0][0] - 0.5, (double)v[0][1] - 0.5, (double)v[0][2] - 0.5), (Direction)side).add(0.5, 0.5, 0.5);
                        Vec3 v2 = CableModelBase.rotate((Vec3)new Vec3((double)v[1][0] - 0.5, (double)v[1][1] - 0.5, (double)v[1][2] - 0.5), (Direction)side).add(0.5, 0.5, 0.5);
                        Vec3 v3 = CableModelBase.rotate((Vec3)new Vec3((double)v[2][0] - 0.5, (double)v[2][1] - 0.5, (double)v[2][2] - 0.5), (Direction)side).add(0.5, 0.5, 0.5);
                        Vec3 v4 = CableModelBase.rotate((Vec3)new Vec3((double)v[3][0] - 0.5, (double)v[3][1] - 0.5, (double)v[3][2] - 0.5), (Direction)side).add(0.5, 0.5, 0.5);
                        Direction realSide = this.getSideFromVecs(v1, v2, v3);
                        boolean invert = i == 2 || i == 1;
                        int length = hasPart ? 1 : 6;
                        int[] data = Ints.concat((int[][])new int[][]{CableModelBase.vertexToInts((float)((float)v1.x), (float)((float)v1.y), (float)((float)v1.z), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v2.x), (float)((float)v2.y), (float)((float)v2.z), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? (float)length : 0.0f)), CableModelBase.vertexToInts((float)((float)v3.x), (float)((float)v3.y), (float)((float)v3.z), (int)-1, (TextureAtlasSprite)texture, (float)10.0f, (float)(invert ? 0.0f : (float)length)), CableModelBase.vertexToInts((float)((float)v4.x), (float)((float)v4.y), (float)((float)v4.z), (int)-1, (TextureAtlasSprite)texture, (float)6.0f, (float)(invert ? 0.0f : (float)length))});
                        ++i;
                        ClientHooks.fillNormal((int[])data);
                        ret.add(new BakedQuad(data, -1, realSide, texture, true, 0, true));
                    }
                    continue;
                }
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)0.625f, (TextureAtlasSprite)texture, (Direction)side);
            }
            if (blockStateHolder.isPresent() && this.shouldRenderParts(this.modelData) && this.renderType != null) {
                BlockStateModel facadeModel = IModHelpers.get().getRenderHelpers().getBakedModel(blockStateHolder.get());
                for (Direction side : Direction.values()) {
                    boolean hasPart;
                    boolean isConnected = this.isItemStack() ? side == Direction.EAST || side == Direction.WEST : this.isConnected(this.modelData, side);
                    PartRenderPosition partRenderPosition = PartRenderPosition.NONE;
                    boolean bl = hasPart = !this.isItemStack() && this.hasPart(this.modelData, side);
                    if (hasPart) {
                        partRenderPosition = this.getPartRenderPosition(this.modelData, side);
                    } else if (isConnected) {
                        partRenderPosition = CABLE_RENDERPOSITION;
                    }
                    ret.addAll(this.getFacadeQuads(facadeModel, blockStateHolder.get(), side, partRenderPosition, this.renderType));
                }
            }
            if (this.isItemStack()) {
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.EAST);
                CableModelBase.addBakedQuad((List)ret, (float)0.375f, (float)0.625f, (float)0.375f, (float)0.625f, (float)1.0f, (TextureAtlasSprite)texture, (Direction)Direction.WEST);
            }
            cachedQuads = ret;
            if (cacheKey != null) {
                CACHE_QUADS.put((Object)cacheKey, (Object)cachedQuads);
            }
        }
        return cachedQuads;
    }

    public TextureAtlasSprite particleIcon() {
        return BlockCableClientConfig.BLOCK_TEXTURE;
    }

    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, BlockEntityMultipartTicking.class).map(BlockEntityMultipartTicking::getConnectionState).orElse(ModelData.EMPTY);
    }

    public boolean usesBlockLight() {
        return false;
    }

    public ItemTransforms getTopTransforms() {
        return TRANSFORMS;
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of(ChunkSectionLayer.values());
    }
}

