/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public abstract class BlockEntityActiveVariableBase<E>
extends BlockEntityCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<E> {
    private final InventoryVariableEvaluator<IValue> evaluator;

    public BlockEntityActiveVariableBase(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState, inventorySize, 1);
        this.getInventory().addDirtyMarkListener((IDirtyMarkListener)this);
        this.evaluator = this.createEvaluator();
    }

    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((Container)this.getInventory(), this.getSlotRead(), () -> ValueDeseralizationContext.of(this.getLevel()), ValueTypes.CATEGORY_ANY);
    }

    public InventoryVariableEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        List<MutableComponent> errors = this.evaluator.getErrors();
        NBTClassType.writeNbt(List.class, (String)"errors", errors, (ValueOutput)output);
    }

    @Override
    public void read(ValueInput input) {
        this.evaluator.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors", (ValueInput)input));
        super.read(input);
    }

    public abstract int getSlotRead();

    public boolean hasVariable() {
        return !this.getInventory().getItem(this.getSlotRead()).isEmpty();
    }

    protected void updateReadVariable(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.getNetwork(), sendVariablesUpdateEvent);
        this.sendUpdate();
    }

    public void onDirty() {
        if (!this.level.isClientSide()) {
            this.updateReadVariable(true);
        }
    }

    @Nullable
    public IVariable<?> getVariable(IPartNetwork network) {
        return this.evaluator.getVariable(this.getNetwork(), network);
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, E networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.updateReadVariable(false);
        }
    }

    @Override
    public void afterNetworkReAlive() {
        super.afterNetworkReAlive();
        this.updateReadVariable(true);
    }

    public static class CapabilityRegistrar<T extends BlockEntityActiveVariableBase<?>>
    extends BlockEntityCableConnectableInventory.CapabilityRegistrar<T> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends T>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.ValueInterface.BLOCK, (blockEntity, context) -> () -> {
                IVariable<?> variable;
                INetwork network = blockEntity.getNetwork();
                IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
                if (blockEntity.hasVariable() && (variable = blockEntity.getVariable(partNetwork)) != null) {
                    return Optional.of(variable.getValue());
                }
                return Optional.empty();
            });
        }
    }
}

