/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class IterativeFunction
implements OperatorBase.IFunction {
    private final List<IOperatorValuePropagator<?, ?>> valuePropagators;

    public IterativeFunction(List<IOperatorValuePropagator<?, ?>> valuePropagators) {
        this.valuePropagators = valuePropagators;
    }

    @Override
    public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
        OperatorBase.SafeVariablesGetter output = variables;
        for (IOperatorValuePropagator<?, ?> valuePropagator : this.valuePropagators) {
            output = valuePropagator.getOutput(output);
        }
        return (IValue)((Object)output);
    }

    public static class PrePostBuilder<O, P> {
        private final List<IOperatorValuePropagator<?, ?>> preValuePropagators;
        private final List<IOperatorValuePropagator<?, ?>> postValuePropagators;

        private PrePostBuilder(List<IOperatorValuePropagator<?, ?>> preValuePropagators, List<IOperatorValuePropagator<?, ?>> postValuePropagators) {
            this.preValuePropagators = preValuePropagators;
            this.postValuePropagators = postValuePropagators;
        }

        public static PrePostBuilder<OperatorBase.SafeVariablesGetter, IValue> begin() {
            return new PrePostBuilder<OperatorBase.SafeVariablesGetter, IValue>(Collections.emptyList(), Collections.emptyList());
        }

        public <O2> PrePostBuilder<O2, P> appendPre(IOperatorValuePropagator<O, O2> valuePropagator) {
            return new PrePostBuilder<O, P>(Helpers.joinList(this.preValuePropagators, valuePropagator), Lists.newArrayList(this.postValuePropagators));
        }

        public <P2> PrePostBuilder<O, P2> appendPost(IOperatorValuePropagator<P2, P> valuePropagator) {
            return new PrePostBuilder<O, P>(Lists.newArrayList(this.preValuePropagators), Helpers.joinList(this.postValuePropagators, valuePropagator));
        }

        public IterativeFunction build(IOperatorValuePropagator<O, P> valuePropagator) {
            ArrayList valuePropagators = Lists.newArrayListWithExpectedSize((int)(this.preValuePropagators.size() + this.postValuePropagators.size()));
            valuePropagators.addAll(this.preValuePropagators);
            valuePropagators.add(valuePropagator);
            valuePropagators.addAll(this.postValuePropagators);
            return new IterativeFunction(valuePropagators);
        }
    }
}

