/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueCastRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueCastMappings {
    public static final IValueCastRegistry REGISTRY = ValueCastMappings.constructRegistry();

    private static IValueCastRegistry constructRegistry() {
        if (IModHelpers.get().getMinecraftHelpers().isModdedEnvironment()) {
            return (IValueCastRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IValueCastRegistry.class);
        }
        return ValueCastRegistry.getInstance();
    }

    public static void load() {
        if (REGISTRY.size() > 0) {
            return;
        }
        REGISTRY.register(ValueTypes.INTEGER, ValueTypes.DOUBLE, new IValueCastRegistry.IMapping<ValueTypeInteger, ValueTypeDouble, ValueTypeInteger.ValueInteger, ValueTypeDouble.ValueDouble>(){

            @Override
            public ValueTypeDouble.ValueDouble cast(ValueTypeInteger.ValueInteger value) {
                return ValueTypeDouble.ValueDouble.of(value.getRawValue());
            }
        });
        REGISTRY.register(ValueTypes.INTEGER, ValueTypes.LONG, new IValueCastRegistry.IMapping<ValueTypeInteger, ValueTypeLong, ValueTypeInteger.ValueInteger, ValueTypeLong.ValueLong>(){

            @Override
            public ValueTypeLong.ValueLong cast(ValueTypeInteger.ValueInteger value) {
                return ValueTypeLong.ValueLong.of(value.getRawValue());
            }
        });
        REGISTRY.register(ValueTypes.DOUBLE, ValueTypes.INTEGER, new IValueCastRegistry.IMapping<ValueTypeDouble, ValueTypeInteger, ValueTypeDouble.ValueDouble, ValueTypeInteger.ValueInteger>(){

            @Override
            public ValueTypeInteger.ValueInteger cast(ValueTypeDouble.ValueDouble value) {
                return ValueTypeInteger.ValueInteger.of((int)value.getRawValue());
            }
        });
        REGISTRY.register(ValueTypes.DOUBLE, ValueTypes.LONG, new IValueCastRegistry.IMapping<ValueTypeDouble, ValueTypeLong, ValueTypeDouble.ValueDouble, ValueTypeLong.ValueLong>(){

            @Override
            public ValueTypeLong.ValueLong cast(ValueTypeDouble.ValueDouble value) {
                return ValueTypeLong.ValueLong.of((long)value.getRawValue());
            }
        });
        REGISTRY.register(ValueTypes.LONG, ValueTypes.INTEGER, new IValueCastRegistry.IMapping<ValueTypeLong, ValueTypeInteger, ValueTypeLong.ValueLong, ValueTypeInteger.ValueInteger>(){

            @Override
            public ValueTypeInteger.ValueInteger cast(ValueTypeLong.ValueLong value) {
                return ValueTypeInteger.ValueInteger.of((int)value.getRawValue());
            }
        });
        REGISTRY.register(ValueTypes.LONG, ValueTypes.DOUBLE, new IValueCastRegistry.IMapping<ValueTypeLong, ValueTypeDouble, ValueTypeLong.ValueLong, ValueTypeDouble.ValueDouble>(){

            @Override
            public ValueTypeDouble.ValueDouble cast(ValueTypeLong.ValueLong value) {
                return ValueTypeDouble.ValueDouble.of(value.getRawValue());
            }
        });
    }
}

