/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.CastOperator;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;

public final class ValueCastRegistry
implements IValueCastRegistry {
    private static ValueCastRegistry INSTANCE = new ValueCastRegistry();
    private final Map<Pair<IValueType, IValueType>, IValueCastRegistry.IMapping> mappings = Maps.newHashMap();

    private ValueCastRegistry() {
    }

    public static ValueCastRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public int size() {
        return this.mappings.size();
    }

    @Override
    public <T1 extends IValueType<V1>, T2 extends IValueType<V2>, V1 extends IValue, V2 extends IValue> void register(T1 from, T2 to, IValueCastRegistry.IMapping<T1, T2, V1, V2> mapping) {
        this.mappings.put((Pair<IValueType, IValueType>)Pair.of(from, to), mapping);
        Operators.REGISTRY.register(new CastOperator<T1, T2, V1, V2>(from, to, mapping));
    }

    @Override
    public <T1 extends IValueType<V1>, T2 extends IValueType<V2>, V1 extends IValue, V2 extends IValue> V2 cast(T2 target, V1 value) throws IValueCastRegistry.ValueCastException {
        IValueCastRegistry.IMapping mapping = this.mappings.get(Pair.of((Object)value.getType(), target));
        if (mapping == null) {
            throw new IValueCastRegistry.ValueCastException(value.getType(), target);
        }
        return mapping.cast(value);
    }

    @Override
    public <T1 extends IValueType<V1>, T2 extends IValueType<V2>, V1 extends IValue, V2 extends IValue> boolean canCast(T2 target, V1 value) {
        return this.mappings.containsKey(Pair.of((Object)value.getType(), target));
    }
}

