/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyPositioned;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyPositionedInventory
extends ValueTypeListProxyPositioned<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack>
implements INBTProvider {
    public ValueTypeListProxyPositionedInventory(DimPos pos, Direction side) {
        super(ValueTypeListProxyFactories.POSITIONED_INVENTORY.getName(), ValueTypes.OBJECT_ITEMSTACK, pos, side);
    }

    public ValueTypeListProxyPositionedInventory() {
        this(null, null);
    }

    protected Optional<IItemHandler> getInventory() {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(this.getPos(), (Object)this.getSide(), Capabilities.ItemHandler.BLOCK);
    }

    @Override
    public int getLength() {
        return this.getInventory().map(IItemHandler::getSlots).orElse(0);
    }

    @Override
    public ValueObjectTypeItemStack.ValueItemStack get(int index) {
        return ValueObjectTypeItemStack.ValueItemStack.of(this.getInventory().map(itemHandler -> itemHandler.getStackInSlot(index)).orElse(ItemStack.EMPTY));
    }

    @Override
    public Iterator<ValueObjectTypeItemStack.ValueItemStack> iterator() {
        return this.getInventory().map(itemHandler -> new ListFactoryIterator((IItemHandler)itemHandler)).orElse((Iterator)Iterators.forArray((Object[])new ValueObjectTypeItemStack.ValueItemStack[0]));
    }

    public static class ListFactoryIterator
    implements Iterator<ValueObjectTypeItemStack.ValueItemStack> {
        @Nullable
        private final IItemHandler itemHandler;
        private int index = 0;

        public ListFactoryIterator(@Nullable IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
        }

        @Override
        public boolean hasNext() {
            return this.itemHandler != null && this.index < this.itemHandler.getSlots();
        }

        @Override
        public ValueObjectTypeItemStack.ValueItemStack next() {
            return ValueObjectTypeItemStack.ValueItemStack.of(this.itemHandler == null ? ItemStack.EMPTY : this.itemHandler.getStackInSlot(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

