/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;
import org.cyclops.integrateddynamics.core.TickHandler;
import org.cyclops.integrateddynamics.core.network.Network;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public class NetworkHelpers {
    @Deprecated
    public static Optional<INetworkCarrier> getNetworkCarrier(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.NetworkCarrier.BLOCK);
    }

    public static Optional<INetworkCarrier> getNetworkCarrier(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return Optional.ofNullable((INetworkCarrier)world.getCapability(Capabilities.NetworkCarrier.BLOCK, pos, blockState, null, (Object)side));
    }

    @Deprecated
    public static Optional<INetworkElementProvider> getNetworkElementProvider(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.NetworkElementProvider.BLOCK);
    }

    public static Optional<INetworkElementProvider> getNetworkElementProvider(ILevelExtension world, BlockPos pos, @Nullable Direction side, BlockState blockState) {
        return Optional.ofNullable((INetworkElementProvider)world.getCapability(Capabilities.NetworkElementProvider.BLOCK, pos, blockState, null, (Object)side));
    }

    public static Optional<INetwork> getNetwork(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        Optional<Optional> networkCarried = NetworkHelpers.getNetworkCarrier(world, pos, side).map(carrier -> {
            INetwork network = carrier.getNetwork();
            return network != null ? Optional.of(network) : Optional.empty();
        });
        return networkCarried.orElse(Optional.empty());
    }

    public static Optional<INetwork> getNetwork(PartPos pos) {
        return NetworkHelpers.getNetwork((ILevelExtension)pos.getPos().getLevel(true), pos.getPos().getBlockPos(), pos.getSide());
    }

    public static INetwork getNetworkChecked(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return NetworkHelpers.getNetwork(world, pos, side).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static INetwork getNetworkChecked(PartPos pos) {
        return NetworkHelpers.getNetwork(pos).orElseThrow(() -> new IllegalStateException("Could not find a network container at " + pos.toString()));
    }

    public static Optional<IPartNetwork> getPartNetwork(Optional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(Capabilities.PartNetwork.NETWORK)).orElse(Optional.empty());
    }

    public static Optional<IPartNetwork> getPartNetwork(@Nullable INetwork network) {
        if (network == null) {
            return Optional.empty();
        }
        return network.getCapability(Capabilities.PartNetwork.NETWORK);
    }

    public static IPartNetwork getPartNetworkChecked(INetwork network) {
        return network.getCapability(Capabilities.PartNetwork.NETWORK).orElseThrow(() -> new IllegalStateException("Could not find a network's part network"));
    }

    public static Optional<IEnergyNetwork> getEnergyNetwork(Optional<INetwork> optionalNetwork) {
        return optionalNetwork.map(network -> network.getCapability(Capabilities.EnergyNetwork.NETWORK)).orElse(Optional.empty());
    }

    public static Optional<IEnergyNetwork> getEnergyNetwork(@Nullable INetwork network) {
        if (network == null) {
            return Optional.empty();
        }
        return network.getCapability(Capabilities.EnergyNetwork.NETWORK);
    }

    public static IEnergyNetwork getEnergyNetworkChecked(INetwork network) {
        return network.getCapability(Capabilities.EnergyNetwork.NETWORK).orElseThrow(() -> new IllegalStateException("Could not find a network's energy network"));
    }

    public static <T, M> Optional<IPositionedAddonsNetworkIngredients<T, M>> getIngredientNetwork(Optional<INetwork> optionalNetwork, IngredientComponent<T, M> ingredientComponent) {
        return optionalNetwork.map(network -> ingredientComponent.getCapability(Capabilities.PositionedAddonsNetworkIngredientsHandler.INGREDIENT).map(handler -> handler.getStorage((INetwork)network)).orElse(Optional.empty())).orElse(Optional.empty());
    }

    public static Optional<INetwork> initNetwork(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(world, pos, (Object)side, Capabilities.PathElement.BLOCK).map(pathElement -> {
            Network network = Network.initiateNetworkSetup(SidedPathElement.of(pathElement, side));
            network.initialize();
            return Optional.of(network);
        }).orElse(Optional.empty());
    }

    public static void onElementProviderBlockNeighborChange(Level world, BlockPos pos, @Nullable Direction side) {
        if (!world.isClientSide()) {
            NetworkHelpers.getNetwork((ILevelExtension)world, pos, side).ifPresent(network -> NetworkHelpers.getNetworkElementProvider((ILevelExtension)world, pos, side).ifPresent(networkElementProvider -> {
                for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                    networkElement.onNeighborBlockChange((INetwork)network, (BlockGetter)world);
                }
            }));
        }
    }

    public static boolean shouldWork() {
        return !GeneralConfig.safeMode;
    }

    public static void invalidateNetworkElements(Level world, BlockPos pos, INetwork network, INetworkElementProvider networkElementProvider) {
        for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
            networkElement.invalidate(network);
        }
    }

    public static void revalidateNetworkElements(Level world, BlockPos pos) {
        INetworkCarrier networkCarrier = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, Capabilities.NetworkCarrier.BLOCK).orElse(null);
        IPathElement pathElement = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, Capabilities.PathElement.BLOCK).orElse(null);
        if (TickHandler.getInstance().ticked && networkCarrier != null && pathElement != null && networkCarrier.getNetwork() == null && IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, Capabilities.CableFakeable.BLOCK).map(ICableFakeable::isRealCable).orElse(false).booleanValue()) {
            IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, Capabilities.NetworkElementProvider.BLOCK).ifPresent(networkElementProvider -> {
                boolean foundNetwork = false;
                for (INetwork network : ((NetworkWorldStorage)NetworkWorldStorage.Access.getInstance(IntegratedDynamics._instance).get()).getNetworks()) {
                    if (!network.containsSidedPathElement(SidedPathElement.of(pathElement, null))) continue;
                    for (INetworkElement networkElement : networkElementProvider.createNetworkElements(world, pos)) {
                        networkElement.revalidate(network);
                    }
                    foundNetwork = true;
                    break;
                }
                if (!foundNetwork && GeneralConfig.recreateCorruptedNetworks) {
                    IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("Detected network position at position %s in world %s with corrupted network, recreating network...", pos, world.dimension().location()));
                    NetworkHelpers.initNetwork((ILevelExtension)world, pos, null);
                }
            });
        }
    }
}

