/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentHandler;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.ingredient.IngredientComponentHandlers;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPatternCommon;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeIngredientsLPElementClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeIngredientsValueChangedPacket;

public class ValueTypeIngredientsLPElement
extends ValueTypeLPElementBase<ValueTypeIngredientsLPElementClient> {
    public static final int OFFSET_X = 20;
    public static final int OFFSET_Y = 21;
    private IngredientComponent currentType = IngredientComponent.ITEMSTACK;
    private Map<IngredientComponent, Integer> lengths = Maps.newHashMap();
    private Map<IngredientComponent, Map<Integer, IValueTypeLogicProgrammerElement>> subElements = Maps.newHashMap();
    private int activeElement = -1;
    private ValueObjectTypeIngredients.ValueIngredients serverValue = null;

    public ValueTypeIngredientsLPElement() {
        super(ValueTypes.OBJECT_INGREDIENTS);
    }

    public void setServerValue(ValueObjectTypeIngredients.ValueIngredients serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ValueTypeIngredientsLPElementClient constructClient() {
        return new ValueTypeIngredientsLPElementClient(this);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS_WIDE;
    }

    @Override
    public boolean canWriteElementPre() {
        return true;
    }

    protected IMixedIngredients constructValues() {
        IdentityHashMap lists = Maps.newIdentityHashMap();
        for (IngredientComponent<?, ?> component : IngredientComponentHandlers.REGISTRY.getComponents()) {
            ArrayList values = Lists.newArrayListWithExpectedSize((int)this.lengths.get(component));
            this.subElements.get(component).entrySet().forEach(entry -> {
                IIngredientComponentHandler componentHandler = IngredientComponentHandlers.REGISTRY.getComponentHandler(component);
                try {
                    values.add(componentHandler.toInstance(((IValueTypeLogicProgrammerElement)entry.getValue()).getValue()));
                }
                catch (Exception e) {
                    values.add(component.getMatcher().getEmptyInstance());
                }
            });
            if (values.isEmpty()) continue;
            lists.put(component, values);
        }
        return new MixedIngredients((Map)lists);
    }

    @Override
    public IValue getValue() {
        return IModHelpers.get().getMinecraftHelpers().isClientSideThread() ? ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues()) : this.serverValue;
    }

    @Override
    public void setValue(IValue value) {
        ValueObjectTypeIngredients.ValueIngredients valueIngredients = (ValueObjectTypeIngredients.ValueIngredients)value;
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            this.setServerValue(valueIngredients);
        }
        valueIngredients.getRawValue().ifPresent(ingredients -> {
            this.currentType = ingredients.getComponents().contains(IngredientComponent.ITEMSTACK) ? IngredientComponent.ITEMSTACK : null;
            for (IngredientComponent ingredientComponent : ingredients.getComponents()) {
                IIngredientComponentHandler handler = IngredientComponentHandlers.REGISTRY.getComponentHandler(ingredientComponent);
                if (this.currentType == null) {
                    this.currentType = ingredientComponent;
                }
                this.lengths.put(ingredientComponent, ingredients.getInstances(ingredientComponent).size());
                HashMap entries = Maps.newHashMap();
                List instances = ingredients.getInstances(ingredientComponent);
                for (int i = 0; i < instances.size(); ++i) {
                    this.initializeElementFromInstanceValue(entries, handler, instances.get(i), i);
                }
                this.subElements.put(ingredientComponent, entries);
            }
        });
    }

    protected <VT extends IValueType<V>, V extends IValue, T, M> void initializeElementFromInstanceValue(Map<Integer, IValueTypeLogicProgrammerElement> entries, IIngredientComponentHandler<VT, V, T, M> handler, T instance, int instanceIndex) {
        V instanceValue = handler.toValue(instance);
        IValueTypeLogicProgrammerElement lpElement = instanceValue.getType().createLogicProgrammerElement();
        lpElement.setValue((IValue)instanceValue);
        entries.put(instanceIndex, lpElement);
    }

    @Override
    public void setValueInContainer(ContainerLogicProgrammerBase container) {
        if (!this.subElements.get(this.currentType).isEmpty()) {
            IValueTypeLogicProgrammerElement subElement = this.setActiveElement(0);
            int x = RenderPatternCommon.calculateX(88, 160, subElement.getRenderPattern()) + 88 - 20;
            int y = RenderPatternCommon.calculateY(18, 87, subElement.getRenderPattern()) + 18 - 21;
            container.setElementInventory(subElement, x, y);
            subElement.setValueInContainer(container);
        }
    }

    public int getLength() {
        return this.lengths.get(this.currentType);
    }

    public void setLength(int length) {
        this.lengths.put(this.currentType, length);
        this.setActiveElement(this.getLength() - 1);
    }

    public IngredientComponent getCurrentType() {
        return this.currentType;
    }

    public void setCurrentType(IngredientComponent currentType) {
        this.currentType = currentType;
        this.setActiveElement(this.subElements.get(currentType).size() - 1);
    }

    public int getActiveElement() {
        return this.activeElement;
    }

    public IValueTypeLogicProgrammerElement setActiveElement(int index) {
        this.activeElement = index;
        IValueTypeLogicProgrammerElement subElement = null;
        if (index >= 0) {
            if (!this.subElements.get(this.currentType).containsKey(index)) {
                subElement = IngredientComponentHandlers.REGISTRY.getComponentHandler(this.currentType).getValueType().createLogicProgrammerElement();
                this.subElements.get(this.currentType).put(index, subElement);
            } else {
                subElement = this.subElements.get(this.currentType).get(index);
            }
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            ((ValueTypeIngredientsLPElementClient)this.getClient()).setActiveElement(this.activeElement);
        }
        return subElement;
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements.get(this.currentType);
        this.subElements.put(this.currentType, Maps.newHashMap());
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.get(this.currentType).put(i, entry.getValue());
                continue;
            }
            if (i <= index) continue;
            this.subElements.get(this.currentType).put(i - 1, entry.getValue());
        }
        ((ValueTypeIngredientsLPElementClient)this.getClient()).removeElement(index);
        this.setLength(this.getLength() - 1);
    }

    public Map<IngredientComponent, Map<Integer, IValueTypeLogicProgrammerElement>> getSubElements() {
        return this.subElements;
    }

    @Override
    public void activate() {
        for (IngredientComponent<?, ?> recipeComponent : IngredientComponentHandlers.REGISTRY.getComponents()) {
            this.subElements.put(recipeComponent, Maps.newHashMap());
            this.lengths.put(recipeComponent, 0);
        }
        ((ValueTypeIngredientsLPElementClient)this.getClient()).activate();
    }

    @Override
    public void deactivate() {
    }

    @Override
    public Component validate() {
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            return this.serverValue == null ? Component.literal((String)"") : null;
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeIngredientsValueChangedPacket(ValueDeseralizationContext.ofClient(), ValueObjectTypeIngredients.ValueIngredients.of(this.constructValues())));
        }
        for (Map<Integer, IValueTypeLogicProgrammerElement> componentValues : this.subElements.values()) {
            for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : componentValues.entrySet()) {
                Component error = entry.getValue().validate();
                if (error == null) continue;
                return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_list_element", (Object[])new Object[]{entry.getKey(), error});
            }
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.get(this.currentType).containsKey(this.activeElement) && this.subElements.get(this.currentType).get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }
}

