/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPatternCommon;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeListLPElementClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeListValueChangedPacket;

public class ValueTypeListLPElement
extends ValueTypeLPElementBase<ValueTypeListLPElementClient> {
    private IValueType listValueType;
    private Map<Integer, IValueTypeLogicProgrammerElement> subElements;
    private int length = 0;
    private int activeElement = -1;
    private ValueTypeList.ValueList serverValue = null;

    public ValueTypeListLPElement() {
        super(ValueTypes.LIST);
    }

    public void setServerValue(ValueTypeList.ValueList serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ValueTypeListLPElementClient constructClient() {
        return new ValueTypeListLPElementClient(this);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS_WIDE;
    }

    @Override
    public boolean canWriteElementPre() {
        return IModHelpers.get().getMinecraftHelpers().isClientSideThread() ? this.listValueType != null : this.serverValue != null;
    }

    protected List<IValue> constructValues() {
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)this.length);
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> value : this.subElements.entrySet()) {
            if (value.getValue().validate() == null) {
                valueList.add(value.getKey(), value.getValue().getValue());
                continue;
            }
            valueList.add(value.getKey(), this.listValueType.getDefault());
        }
        return valueList;
    }

    @Override
    public IValue getValue() {
        return IModHelpers.get().getMinecraftHelpers().isClientSideThread() ? ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues()) : this.serverValue;
    }

    @Override
    public void setValue(IValue value) {
        IValueTypeListProxy list;
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            this.serverValue = (ValueTypeList.ValueList)value;
        }
        if (!(list = ((ValueTypeList.ValueList)value).getRawValue()).isInfinite()) {
            this.setListValueType((IValueType)list.getValueType());
            try {
                int length;
                this.length = length = list.getLength();
                for (int i = 0; i < length; ++i) {
                    this.initializeElement(i).setValue((IValue)list.get(i));
                }
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setValueInContainer(ContainerLogicProgrammerBase container) {
        if (this.length > 0) {
            IValueTypeLogicProgrammerElement subElement = this.setActiveElement(0);
            int x = RenderPatternCommon.calculateX(88, 160, subElement.getRenderPattern());
            int y = RenderPatternCommon.calculateY(18, 87, subElement.getRenderPattern());
            container.setElementInventory(subElement, x, y);
            container.getTemporaryInputSlots().removeDirtyMarkListener((IDirtyMarkListener)container);
            subElement.setValueInContainer(container);
            container.getTemporaryInputSlots().addDirtyMarkListener((IDirtyMarkListener)container);
        }
    }

    public IValueType getListValueType() {
        return this.listValueType;
    }

    public void setListValueType(IValueType listValueType) {
        this.listValueType = listValueType;
        this.reset();
    }

    public void reset() {
        this.subElements = Maps.newHashMap();
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            ((ValueTypeListLPElementClient)this.getClient()).reset();
        }
        this.setLength(0);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        this.setActiveElement(length - 1);
    }

    public IValueTypeLogicProgrammerElement initializeElement(int index) {
        IValueTypeLogicProgrammerElement subElement = this.listValueType.createLogicProgrammerElement();
        subElement.activate();
        this.subElements.put(index, subElement);
        return subElement;
    }

    public int getActiveElement() {
        return this.activeElement;
    }

    public IValueTypeLogicProgrammerElement setActiveElement(int index) {
        IValueTypeLogicProgrammerElement subElement;
        this.activeElement = index;
        if (index >= 0 && !this.subElements.containsKey(index)) {
            subElement = this.initializeElement(index);
            subElement.activate();
        } else {
            subElement = this.subElements.get(index);
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            ((ValueTypeListLPElementClient)this.getClient()).setActiveElement(this.activeElement);
        }
        return subElement;
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements;
        this.subElements = Maps.newHashMap();
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.put(i, entry.getValue());
                continue;
            }
            if (i <= index) continue;
            this.subElements.put(i - 1, entry.getValue());
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            ((ValueTypeListLPElementClient)this.getClient()).removeElement(index);
        }
        this.setLength(this.length - 1);
    }

    public Map<Integer, IValueTypeLogicProgrammerElement> getSubElements() {
        return this.subElements;
    }

    @Override
    public void activate() {
        this.reset();
    }

    @Override
    public void deactivate() {
        this.activeElement = -1;
    }

    @Override
    public Component validate() {
        if (!IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            return this.serverValue == null ? Component.literal((String)"") : null;
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSideThread()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeListValueChangedPacket(ValueDeseralizationContext.ofClient(), this.listValueType == null ? ValueTypes.LIST.getDefault() : ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues())));
        }
        if (this.listValueType == null) {
            return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_input_item");
        }
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : this.subElements.entrySet()) {
            Component error = entry.getValue().validate();
            if (error == null) continue;
            return Component.translatable((String)"valuetype.integrateddynamics.error.invalid_list_element", (Object[])new Object[]{entry.getKey(), error});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.containsKey(this.activeElement) && this.subElements.get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }
}

