/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementClient;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPatternCommon;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeListLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeLPElementBaseClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;

public class ValueTypeListLPElementClient
extends ValueTypeLPElementBaseClient<ValueTypeListLPElement> {
    private MasterSubGuiRenderPattern masterGui;
    private Map<Integer, RenderPattern> subElementGuis;

    public ValueTypeListLPElementClient(ValueTypeListLPElement element) {
        super(element);
    }

    @Override
    public void setValueInGui(ISubGuiBox subGui) {
        if (((ValueTypeListLPElement)this.getElement()).getLength() > 0) {
            this.masterGui.setSelectedValueType(((ValueTypeListLPElement)this.getElement()).getListValueType());
            this.setActiveElement(0);
        }
    }

    @Override
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern((ValueTypeListLPElement)this.getElement(), baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    public void setActiveElement(int activeElement) {
        this.masterGui.setActiveElement(activeElement);
        this.masterGui.container.onDirty();
    }

    public void reset() {
        this.subElementGuis = Maps.newHashMap();
    }

    public void removeElement(int index) {
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis;
        this.subElementGuis = Maps.newHashMap();
        for (Map.Entry<Integer, RenderPattern> entry : oldSubElementGuis.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElementGuis.put(i, entry.getValue());
                continue;
            }
            if (i <= index) continue;
            this.subElementGuis.put(i - 1, entry.getValue());
        }
    }

    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final ContainerScreenLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        private final SelectionSubGui selectionGui;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.selectionGui = new SelectionSubGui(element, baseX, baseY - this.getHeight() / 4, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(this.selectionGui);
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeListLPElement)this.element, this.baseX, this.baseY, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.init(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        public void setSelectedValueType(IValueType valueType) {
            this.selectionGui.setActiveElement(valueType);
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, guiGraphics, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeListLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }

    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase<?>, ContainerLogicProgrammerBase> {
        private ButtonArrow arrowLeft;
        private ButtonArrow arrowRight;
        private Button arrowRemove;
        private RenderPattern subGui;
        private IValueTypeLogicProgrammerElement<RenderPattern, ContainerScreenLogicProgrammerBase<?>, AbstractContainerMenu, ?> subElement;

        public ListElementSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase<?> gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGui = ((ValueTypeListLPElementClient)element.getClient()).subElementGuis.get(element.getActiveElement());
            this.subElement = element.getSubElements().get(element.getActiveElement());
            if (this.subGui == null) {
                this.subGui = (RenderPattern)((ILogicProgrammerElementClient)this.subElement.getClient()).createSubGui(baseX, baseY, maxWidth, maxHeight, gui, container);
                ((ValueTypeListLPElementClient)element.getClient()).subElementGuis.put(element.getActiveElement(), this.subGui);
            }
            int x = RenderPatternCommon.calculateX(baseX, maxWidth, this.subElement.getRenderPattern());
            int y = RenderPatternCommon.calculateY(baseY, maxHeight, this.subElement.getRenderPattern());
            ((ContainerLogicProgrammerBase)gui.getMenu()).setElementInventory(this.subElement, x, y);
            this.subGuiHolder.addSubGui(this.subGui);
            if (this.subGui instanceof IRenderPatternValueTypeTooltip) {
                ((IRenderPatternValueTypeTooltip)((Object)this.subGui)).setRenderTooltip(false);
            }
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory(element.getListValueType(), x, y));
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new ButtonArrow(x, y, (Component)Component.translatable((String)"gui.cyclopscore.left"), b -> ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).getActiveElement() - 1), ButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new ButtonArrow(x + this.getWidth() - this.arrowLeft.getWidth() - 1, y, (Component)Component.translatable((String)"gui.cyclopscore.right"), b -> ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).getActiveElement() + 1), ButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new ButtonText(x + this.getWidth() - this.arrowLeft.getWidth() - 1, y + this.getHeight() - 13, 10, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.remove"), (Component)Component.literal((String)"-"), b -> ((ValueTypeListLPElement)this.element).removeElement(((ValueTypeListLPElement)this.element).getActiveElement()), true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.active = ((ValueTypeListLPElement)this.element).getActiveElement() > 0;
            this.arrowRight.active = ((ValueTypeListLPElement)this.element).getActiveElement() < ((ValueTypeListLPElement)this.element).getLength() - 1;
            this.arrowRemove.active = ((ValueTypeListLPElement)this.element).getLength() > 0;
            ((ContainerLogicProgrammerBase)this.container).getTemporaryInputSlots().removeDirtyMarkListener((IDirtyMarkListener)this.container);
            ((ILogicProgrammerElementClient)this.subElement.getClient()).setValueInGui(this.subGui);
            this.subElement.setValueInContainer((AbstractContainerMenu)this.subGui.container);
            ((ContainerLogicProgrammerBase)this.container).getTemporaryInputSlots().addDirtyMarkListener((IDirtyMarkListener)this.container);
        }
    }

    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeListLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private WidgetArrowedListField<IValueType<?>> valueTypeSelector = null;
        private Button arrowAdd;

        public SelectionSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IValueType<?>> getValueTypes() {
            ArrayList valueTypes = Lists.newArrayList(LogicProgrammerElementTypes.VALUETYPE.getValueTypes());
            valueTypes.remove(ValueTypes.LIST);
            valueTypes.add(ValueTypes.CATEGORY_ANY);
            return valueTypes;
        }

        @Override
        public void init(int guiLeft, int guiTop) {
            super.init(guiLeft, guiTop);
            this.valueTypeSelector = new WidgetArrowedListField(Minecraft.getInstance().font, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 9, 100, 15, true, (Component)Component.translatable((String)"valuetype.integrateddynamics.value_type"), true, SelectionSubGui.getValueTypes());
            this.valueTypeSelector.setListener((IInputListener)this);
            if (((ValueTypeListLPElement)this.element).getActiveElement() == -1) {
                this.onChanged();
            }
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new ButtonText(x + this.getWidth() - 13, y + 10, 12, 12, (Component)Component.translatable((String)"gui.integrateddynamics.button.add"), (Component)Component.literal((String)"+"), b -> {}, true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            return this.valueTypeSelector.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(Button guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeListLPElement)this.element).setLength(((ValueTypeListLPElement)this.element).getLength() + 1);
            }
        }

        @Override
        protected boolean isDrawBackground() {
            return false;
        }

        @Override
        public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.render(guiGraphics, mouseX, mouseY, partialTicks);
            if (((ValueTypeListLPElement)this.element).getActiveElement() >= 0) {
                int x = guiLeft + this.getX() + 10;
                int y = guiTop + this.getY() + 4;
                IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, fontRenderer, String.valueOf(((ValueTypeListLPElement)this.element).getActiveElement()), x - 6, y + 12, 10, IModHelpers.get().getBaseHelpers().RGBAToInt(20, 20, 20, 255), false, Font.DisplayMode.NORMAL);
            }
        }

        public void onChanged() {
            IValueType newType = (IValueType)this.valueTypeSelector.getActiveElement();
            ((ValueTypeListLPElement)this.element).setListValueType(newType);
            if (this.arrowAdd != null) {
                this.arrowAdd.active = newType != ValueTypes.CATEGORY_ANY;
            }
        }

        public void setActiveElement(IValueType valueType) {
            this.valueTypeSelector.setListener(null);
            this.valueTypeSelector.setActiveElement((Object)valueType);
            this.valueTypeSelector.setListener((IInputListener)this);
        }
    }
}

