/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer.client;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.client.ValueTypeRecipeLPElementClient;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

class ValueTypeRecipeLPElementPropertiesSubGui
extends RenderPattern<ValueTypeRecipeLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final int slotId;
    private ButtonCheckbox inputNbt;
    private ButtonCheckbox inputTags;
    private ButtonCheckbox inputReusable;
    private WidgetTextFieldDropdown<ResourceLocation> inputTagsDropdown;
    private ButtonImage inputSave;

    public ValueTypeRecipeLPElementPropertiesSubGui(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container, int slotId) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.slotId = slotId;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.inputNbt = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 2, 20, 10, (Component)Component.translatable((String)"gui.integrateddynamics.recipe.strictnbt"), entry -> {
            if (this.inputNbt.isChecked()) {
                this.inputTags.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
        });
        this.inputReusable = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 12, 20, 10, (Component)Component.translatable((String)"gui.integrateddynamics.recipe.reusable"), entry -> {
            this.saveGuiToState();
            this.loadStateToGui();
        });
        this.inputTags = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 22, 20, 10, (Component)Component.translatable((String)"gui.integrateddynamics.recipe.tagvariants"), entry -> {
            if (this.inputTags.isChecked()) {
                this.inputNbt.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
            if (this.inputTags.isChecked()) {
                this.inputTagsDropdown.setFocused(true);
            }
        });
        this.inputTagsDropdown = new WidgetTextFieldDropdown(Minecraft.getInstance().font, guiLeft + this.getX() + 2, guiTop + this.getY() + 33, 134, 14, (Component)Component.translatable((String)"gui.cyclopscore.search"), true, Sets.newHashSet());
        this.inputTagsDropdown.setDropdownEntryListener(entry -> this.saveGuiToState());
        this.inputTagsDropdown.setMaxLength(64);
        this.inputTagsDropdown.setDropdownSize(4);
        this.inputTagsDropdown.setBordered(false);
        this.inputTagsDropdown.setTextColor(ARGB.opaque((int)0xFFFFFF));
        this.inputTagsDropdown.setCanLoseFocus(true);
        this.inputSave = new ButtonImage(guiLeft + this.getX() + 116, guiTop + this.getY() + 72, (Component)Component.translatable((String)"gui.integrateddynamics.button.save"), button -> {
            if (!this.inputTags.isChecked() || this.inputTagsDropdown.getSelectedDropdownPossibility() != null) {
                ((ValueTypeRecipeLPElementClient)((ValueTypeRecipeLPElement)this.element).getClient()).lastGui.setRecipeSubGui();
            } else {
                this.inputTagsDropdown.setFocused(true);
            }
        }, (IImage)Images.OK);
        this.loadStateToGui();
        if (this.inputTags.isChecked()) {
            this.inputTagsDropdown.setFocused(true);
        }
    }

    public ItemStack getSlotContents() {
        return ((Slot)((ContainerLogicProgrammerBase)this.container).slots.get(this.slotId + 4)).getItem();
    }

    public ItemMatchProperties getSlotProperties() {
        return (ItemMatchProperties)((ValueTypeRecipeLPElement)this.getElement()).getInputStacks().get(this.slotId);
    }

    private Set<IDropdownEntry<ResourceLocation>> getDropdownEntries() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        if (this.getSlotContents().isEmpty()) {
            BuiltInRegistries.ITEM.listTagIds().forEach(registeredTag -> set.add(new DropdownEntry(registeredTag.location())));
        } else {
            this.getSlotContents().getItem().builtInRegistryHolder().tags().forEach(registeredTag -> set.add(new DropdownEntry(registeredTag.location())));
        }
        return set;
    }

    public void loadStateToGui() {
        ItemMatchProperties props = this.getSlotProperties();
        this.inputNbt.setChecked(props.isNbt());
        this.inputTags.setChecked(props.getItemTag() != null);
        this.inputReusable.setChecked(props.isReusable());
        this.inputTagsDropdown.setVisible(this.inputTags.isChecked());
        if (this.inputTags.isChecked()) {
            Set dropdownEntries = this.getDropdownEntries();
            this.inputTagsDropdown.setPossibilities(dropdownEntries);
            if (props.getItemTag() != null) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.stream().filter(e -> e.getMatchString().equals(props.getItemTag())).findFirst().orElse(null));
            } else if (!dropdownEntries.isEmpty()) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.iterator().next());
            } else {
                this.inputTagsDropdown.selectPossibility(null);
            }
        } else {
            this.inputTagsDropdown.setValue("");
            this.inputTagsDropdown.setPossibilities(Collections.emptySet());
        }
    }

    public void saveGuiToState() {
        boolean nbt = this.inputNbt.isChecked();
        String tag = this.inputTags.isChecked() ? this.inputTagsDropdown.getValue() : null;
        this.getSlotProperties().setNbt(nbt);
        this.getSlotProperties().setItemTag(tag);
        this.getSlotProperties().setReusable(this.inputReusable.isChecked());
        ((ValueTypeRecipeLPElement)this.element).sendSlotPropertiesToServer(this.slotId, this.getSlotProperties());
    }

    @Override
    protected boolean drawRenderPattern() {
        return false;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.drawSlot(guiGraphics, this.getX() + guiLeft + 116, this.getY() + guiTop + 2);
        this.inputNbt.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(fontRenderer, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.recipe.strictnbt", new Object[0]), guiLeft + this.getX() + 24, guiTop + this.getY() + 3, ARGB.opaque((int)0), false);
        this.inputReusable.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(fontRenderer, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.recipe.reusable", new Object[0]), guiLeft + this.getX() + 24, guiTop + this.getY() + 13, ARGB.opaque((int)0), false);
        this.inputTags.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(fontRenderer, IModHelpers.get().getL10NHelpers().localize("gui.integrateddynamics.recipe.tagvariants", new Object[0]), guiLeft + this.getX() + 24, guiTop + this.getY() + 23, ARGB.opaque((int)0), false);
        this.inputSave.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.inputTagsDropdown.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        int i;
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        if (this.inputTagsDropdown.isFocused() && (i = this.inputTagsDropdown.getHoveredVisiblePossibility(mouseX, mouseY)) >= 0) {
            IDropdownEntry<ResourceLocation> hoveredPossibility = this.inputTagsDropdown.getVisiblePossibility(i);
            this.drawTagsTooltip(guiGraphics, hoveredPossibility, guiLeft, guiTop, mouseX + 10, mouseY - 20, 6, IModHelpers.get().getGuiHelpers().getSlotSize());
        }
    }

    protected void drawTagsTooltip(GuiGraphics guiGraphics, IDropdownEntry<ResourceLocation> hoveredPossibility, int guiLeft, int guiTop, int mouseX, int mouseY, int columns, int offset) {
        int x = mouseX - guiLeft;
        int y = mouseY - guiTop;
        List<Item> items = BuiltInRegistries.ITEM.get(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)hoveredPossibility.getValue())).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).toList();
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)x, (int)y, (int)(Math.min(items.size(), columns) * offset), (int)(((items.size() % columns == 0 ? 0 : 1) + items.size() / columns) * offset), null);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, 0.0f);
        int passed = 0;
        for (Item item : items) {
            guiGraphics.renderItem(new ItemStack((ItemLike)item), x, y);
            x += offset;
            if (passed++ % columns != columns - 1) continue;
            y += offset;
            x = mouseX - guiLeft;
        }
        guiGraphics.pose().popMatrix();
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.inputTagsDropdown.isFocused() && this.inputTagsDropdown.charTyped(typedChar, keyCode)) {
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.inputTagsDropdown.isFocused()) {
            this.inputTagsDropdown.keyPressed(typedChar, keyCode, modifiers);
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.inputNbt.mouseClicked(mouseX, mouseY, mouseButton) || this.inputReusable.mouseClicked(mouseX, mouseY, mouseButton) || this.inputTags.mouseClicked(mouseX, mouseY, mouseButton) || this.inputTagsDropdown.mouseClicked(mouseX, mouseY, mouseButton) || this.inputSave.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public static class DropdownEntry
    implements IDropdownEntry<ResourceLocation> {
        private final ResourceLocation tag;

        public DropdownEntry(ResourceLocation tag) {
            this.tag = tag;
        }

        @Override
        public String getMatchString() {
            return this.tag.toString();
        }

        @Override
        public MutableComponent getDisplayString() {
            return Component.literal((String)this.tag.toString());
        }

        @Override
        public List<MutableComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public ResourceLocation getValue() {
            return this.tag;
        }
    }
}

