/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.part.PartStateOffsetHandler;
import org.cyclops.integrateddynamics.core.part.aspect.property.AspectProperties;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private boolean forceBlockUpdateRender = false;
    private int updateInterval = this.getDefaultUpdateInterval();
    private int priority = 0;
    private int channel = 0;
    private int maxOffset;
    private Vec3i targetOffset = new Vec3i(0, 0, 0);
    private Direction targetSide = null;
    private int id = -1;
    private Map<IAspect, IAspectProperties> aspectProperties = new IdentityHashMap<IAspect, IAspectProperties>();
    private boolean enabled = true;
    private final Map<String, NonNullList<ItemStack>> inventoriesNamed = Maps.newHashMap();
    private final PartStateOffsetHandler<P> offsetHandler = new PartStateOffsetHandler();
    private IdentityHashMap<PartCapability<?>, Optional<Object>> volatileCapabilities = new IdentityHashMap();

    @Override
    public void serialize(ValueOutput valueOutput) {
        valueOutput.putInt("updateInterval", this.updateInterval);
        valueOutput.putInt("priority", this.priority);
        valueOutput.putInt("channel", this.channel);
        if (this.targetSide != null) {
            valueOutput.putInt("targetSide", this.targetSide.ordinal());
        }
        valueOutput.putInt("id", this.id);
        this.writeAspectProperties(valueOutput.child("aspectProperties"));
        valueOutput.putBoolean("enabled", this.enabled);
        valueOutput.putInt("maxOffset", this.maxOffset);
        valueOutput.putInt("offsetX", this.targetOffset.getX());
        valueOutput.putInt("offsetY", this.targetOffset.getY());
        valueOutput.putInt("offsetZ", this.targetOffset.getZ());
        ValueOutput.ValueOutputList namedInventoriesList = valueOutput.childrenList("inventoriesNamed");
        for (Map.Entry<String, NonNullList<ItemStack>> entry : this.inventoriesNamed.entrySet()) {
            ValueOutput listEntry = namedInventoriesList.addChild();
            listEntry.putString("tabName", entry.getKey());
            listEntry.putInt("itemCount", entry.getValue().size());
            ContainerHelper.saveAllItems((ValueOutput)listEntry, entry.getValue());
        }
        ValueOutput.ValueOutputList errorsTag = valueOutput.childrenList("offsetVariablesSlotMessages");
        for (Int2ObjectMap.Entry entry : this.offsetHandler.offsetVariablesSlotMessages.int2ObjectEntrySet()) {
            ValueOutput child = errorsTag.addChild();
            String slot = String.valueOf(entry.getIntKey());
            child.putString("slot", slot);
            NBTClassType.writeNbt(MutableComponent.class, (String)slot, (Object)((MutableComponent)entry.getValue()), (ValueOutput)child);
        }
    }

    @Override
    public void deserialize(ValueInput valueInput) {
        this.updateInterval = (Integer)valueInput.getInt("updateInterval").orElseThrow();
        this.priority = (Integer)valueInput.getInt("priority").orElseThrow();
        this.channel = (Integer)valueInput.getInt("channel").orElseThrow();
        this.targetSide = valueInput.getInt("targetSide").map(s -> Direction.values()[s]).orElse(null);
        this.id = (Integer)valueInput.getInt("id").orElseThrow();
        this.aspectProperties.clear();
        this.readAspectProperties((ValueInput)valueInput.child("aspectProperties").orElseThrow());
        this.enabled = valueInput.getBooleanOr("enabled", false);
        this.maxOffset = (Integer)valueInput.getInt("maxOffset").orElseThrow();
        this.targetOffset = new Vec3i(((Integer)valueInput.getInt("offsetX").orElseThrow()).intValue(), ((Integer)valueInput.getInt("offsetY").orElseThrow()).intValue(), ((Integer)valueInput.getInt("offsetZ").orElseThrow()).intValue());
        for (ValueInput listEntry : (ValueInput.ValueInputList)valueInput.childrenList("inventoriesNamed").orElseThrow()) {
            NonNullList list = NonNullList.withSize((int)((Integer)listEntry.getInt("itemCount").orElseThrow()), (Object)ItemStack.EMPTY);
            String tabName = (String)listEntry.getString("tabName").orElseThrow();
            ContainerHelper.loadAllItems((ValueInput)listEntry, (NonNullList)list);
            this.inventoriesNamed.put(tabName, (NonNullList<ItemStack>)list);
        }
        this.offsetHandler.offsetVariablesSlotMessages.clear();
        ValueInput.ValueInputList errorsTag = (ValueInput.ValueInputList)valueInput.childrenList("offsetVariablesSlotMessages").orElseThrow();
        for (ValueInput child : errorsTag) {
            String slot = (String)child.getString("slot").orElseThrow();
            MutableComponent unlocalizedString = (MutableComponent)NBTClassType.readNbt(MutableComponent.class, (String)slot, (ValueInput)child);
            this.offsetHandler.offsetVariablesSlotMessages.put(Integer.parseInt(slot), (Object)unlocalizedString);
        }
    }

    protected void writeAspectProperties(ValueOutput valueOutput) {
        ValueOutput.ValueOutputList list = valueOutput.childrenList("map");
        for (Map.Entry<IAspect, IAspectProperties> entry : this.aspectProperties.entrySet()) {
            ValueOutput entryTag = list.addChild();
            entryTag.putString("key", entry.getKey().getUniqueName().toString());
            if (entry.getValue() == null) continue;
            entry.getValue().serialize(entryTag.child("value"));
        }
    }

    public void readAspectProperties(ValueInput valueInput) {
        for (ValueInput entryTag : (ValueInput.ValueInputList)valueInput.childrenList("map").orElseThrow()) {
            IAspect key = Aspects.REGISTRY.getAspect(ResourceLocation.parse((String)((String)entryTag.getString("key").orElseThrow())));
            IAspectProperties value = entryTag.child("value").map(v -> {
                AspectProperties ap = new AspectProperties();
                ap.deserialize((ValueInput)v);
                return ap;
            }).orElse(null);
            if (key == null || value == null) continue;
            this.aspectProperties.put(key, value);
        }
    }

    @Override
    public void generateId() {
        this.id = ((GlobalCounters)IntegratedDynamics.globalCounters.get()).getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public Vec3i getTargetOffset() {
        return this.targetOffset;
    }

    @Override
    public void setTargetOffset(Vec3i targetOffset) {
        this.targetOffset = targetOffset;
        this.markDirty();
    }

    @Override
    public void setTargetSideOverride(Direction targetSide) {
        this.targetSide = targetSide;
    }

    @Override
    @Nullable
    public Direction getTargetSideOverride() {
        return this.targetSide;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    @Override
    public void forceBlockRenderUpdate() {
        this.forceBlockUpdateRender = true;
    }

    @Override
    public boolean isForceBlockRenderUpdateAndReset() {
        boolean wasForceBlockUpdateRender = this.forceBlockUpdateRender;
        this.forceBlockUpdateRender = false;
        return wasForceBlockUpdateRender;
    }

    public void onDirty() {
        this.dirty = true;
        this.forceBlockRenderUpdate();
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect);
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect, properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.enabled != wasEnabled) {
            this.sendUpdate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public NonNullList<ItemStack> getInventoryNamed(String name) {
        return this.inventoriesNamed.get(name);
    }

    @Override
    public void setInventoryNamed(String name, NonNullList<ItemStack> inventory) {
        this.inventoriesNamed.put(name, inventory);
        this.onDirty();
    }

    @Override
    public Map<String, NonNullList<ItemStack>> getInventoriesNamed() {
        return this.inventoriesNamed;
    }

    @Override
    public void clearInventoriesNamed() {
        this.inventoriesNamed.clear();
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        NeoForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        Optional<Object> o = this.volatileCapabilities.get(capability);
        if (o != null && o.isPresent()) {
            return o;
        }
        return Optional.ofNullable(capability.getCapability((IPartType<?, ?>)partType, target));
    }

    @Override
    public <T> void addVolatileCapability(PartCapability<T> capability, Optional<T> value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(PartCapability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    protected int getDefaultUpdateInterval() {
        return GeneralConfig.defaultPartUpdateFreq;
    }

    @Override
    public void initializeOffsets(PartTarget target) {
        this.offsetHandler.initializeVariableEvaluators(this.offsetHandler.getOffsetVariablesInventory(this), target);
    }

    @Override
    public void updateOffsetVariables(P partType, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        this.offsetHandler.updateOffsetVariables(partType, this, network, partNetwork, target);
    }

    @Override
    @Nullable
    public MutableComponent getOffsetVariableError(int slot) {
        return this.offsetHandler.getOffsetVariableError(slot);
    }

    @Override
    public boolean requiresOffsetUpdates() {
        return this.offsetHandler.offsetVariableEvaluators.stream().anyMatch(InventoryVariableEvaluator::hasVariable);
    }

    @Override
    public void markOffsetVariablesChanged() {
        this.offsetHandler.markOffsetVariablesChanged();
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    public void setMaxOffset(int maxOffset) {
        this.maxOffset = maxOffset;
        this.markDirty();
    }
}

