/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.core.helper.Codecs;

public record RecipeDisplaySqueezer(SlotDisplay inputIngredient, List<Pair<? extends SlotDisplay, Float>> outputItems, FluidStack outputFluid, SlotDisplay craftingStation, int duration) implements RecipeDisplay
{
    public static final MapCodec<RecipeDisplaySqueezer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SlotDisplay.CODEC.fieldOf("input_ingredient").forGetter(RecipeDisplaySqueezer::inputIngredient), (App)Codecs.SLOT_DISPLAY_CHANCE.listOf().fieldOf("output_ingredients").forGetter(RecipeDisplaySqueezer::outputItems), (App)FluidStack.CODEC.fieldOf("output_fluid").forGetter(RecipeDisplaySqueezer::outputFluid), (App)SlotDisplay.CODEC.fieldOf("crafting_station").forGetter(RecipeDisplaySqueezer::craftingStation), (App)Codec.INT.fieldOf("duration").forGetter(RecipeDisplaySqueezer::duration)).apply((Applicative)instance, RecipeDisplaySqueezer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeDisplaySqueezer> STREAM_CODEC = StreamCodec.composite((StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplaySqueezer::inputIngredient, (StreamCodec)Codecs.STREAM_SLOT_DISPLAY_CHANCE.apply(ByteBufCodecs.list()), RecipeDisplaySqueezer::outputItems, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, RecipeDisplaySqueezer::outputFluid, (StreamCodec)SlotDisplay.STREAM_CODEC, RecipeDisplaySqueezer::craftingStation, (StreamCodec)ByteBufCodecs.VAR_INT, RecipeDisplaySqueezer::duration, RecipeDisplaySqueezer::new);
    public static final RecipeDisplay.Type<RecipeDisplaySqueezer> TYPE = new RecipeDisplay.Type(MAP_CODEC, STREAM_CODEC);

    public SlotDisplay result() {
        if (this.outputItems().isEmpty()) {
            FluidStack fluidStack = this.outputFluid();
            return new SlotDisplay.ItemSlotDisplay(this.outputFluid().getFluidType().getBucket(fluidStack).getItem());
        }
        return (SlotDisplay)this.outputItems().getFirst().getLeft();
    }

    public RecipeDisplay.Type<? extends RecipeDisplay> type() {
        return TYPE;
    }

    public boolean isEnabled(FeatureFlagSet featureFlagSet) {
        return this.inputIngredient.isEnabled(featureFlagSet) && this.outputItems.stream().allMatch(pair -> ((SlotDisplay)pair.getLeft()).isEnabled(featureFlagSet)) && super.isEnabled(featureFlagSet);
    }
}

