/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.codec.ListCodecStrict;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSerializerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerMechanicalSqueezer
implements RecipeSerializer<RecipeMechanicalSqueezer> {
    public static final MapCodec<RecipeMechanicalSqueezer> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input_item").forGetter(RecipeSqueezer::getInputIngredient), (App)new ListCodecStrict(RecipeSerializerSqueezer.CODEC_INGREDIENT_CHANCE).optionalFieldOf("output_items").forGetter(r -> r.getOutputItems().isEmpty() ? Optional.empty() : Optional.of(r.getOutputItems().stream().toList())), (App)FluidStack.CODEC.optionalFieldOf("output_fluid").forGetter(RecipeSqueezer::getOutputFluid), (App)Codec.INT.fieldOf("duration").forGetter(RecipeMechanicalSqueezer::getDuration)).apply((Applicative)builder, (inputIngredient, outputItemStacks, outputFluid, duration) -> {
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalSqueezer((Ingredient)inputIngredient, (NonNullList<RecipeSqueezer.IngredientChance>)outputItemStacks.map(NonNullList::copyOf).orElseGet(NonNullList::create), (Optional<FluidStack>)outputFluid, (int)duration);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeMechanicalSqueezer> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RecipeSqueezer::getInputIngredient, (StreamCodec)RecipeSerializerSqueezer.STREAM_CODEC_INGREDIENT_CHANCE.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), RecipeSqueezer::getOutputItems, (StreamCodec)ByteBufCodecs.optional((StreamCodec)FluidStack.STREAM_CODEC), RecipeSqueezer::getOutputFluid, (StreamCodec)ByteBufCodecs.INT, RecipeMechanicalSqueezer::getDuration, RecipeMechanicalSqueezer::new);

    public MapCodec<RecipeMechanicalSqueezer> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, RecipeMechanicalSqueezer> streamCodec() {
        return STREAM_CODEC;
    }
}

