/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadEntity {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityItemFrameRotationInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.INTEGER_ITEMFRAMEROTATION, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityItemFrameRotationValid(GameTestHelper helper) {
        ItemFrame itemFrame = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS.west());
        itemFrame.setRotation(3);
        itemFrame.setYRot(Direction.WEST.toYRot());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.INTEGER_ITEMFRAMEROTATION, ValueTypeInteger.ValueInteger.of(3));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityItemFrameContentsInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.ITEMSTACK_ITEMFRAMECONTENTS, ValueObjectTypeItemStack.ValueItemStack.of(ItemStack.EMPTY));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityItemFrameContentsValid(GameTestHelper helper) {
        ItemFrame itemFrame = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS.west());
        itemFrame.setItem(new ItemStack((ItemLike)Items.COAL));
        itemFrame.setYRot(Direction.WEST.toYRot());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.ITEMSTACK_ITEMFRAMECONTENTS, ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.COAL)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityEntities(GameTestHelper helper) {
        Cow cow = (Cow)helper.spawn(EntityType.COW, POS.west());
        Chicken chicken = (Chicken)helper.spawn(EntityType.CHICKEN, POS.west());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.LIST_ENTITIES, ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeEntity.ValueEntity[]{ValueObjectTypeEntity.ValueEntity.of((Entity)cow), ValueObjectTypeEntity.ValueEntity.of((Entity)chicken)}));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityEntity(GameTestHelper helper) {
        Cow cow = (Cow)helper.spawn(EntityType.COW, POS.west());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.ENTITY, ValueObjectTypeEntity.ValueEntity.of((Entity)cow));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadEntityPlayers(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspectPredicate(POS, helper, PartTypes.ENTITY_READER, Aspects.Read.Entity.LIST_PLAYERS, Objects::nonNull);
    }
}

