/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Lists;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectVariable;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.blockentity.BlockEntityVariablestore;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.PartTypePanelDisplay;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadNetwork {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkApplicableTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkApplicableFalse(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.BOOLEAN_APPLICABLE, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkElementCountInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ELEMENT_COUNT, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkElementCountValid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ELEMENT_COUNT, ValueTypeInteger.ValueInteger.of(2));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkBatteryCountInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_BATTERY_COUNT, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkBatteryCountValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        helper.setBlock(POS.west().west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_BATTERY_COUNT, ValueTypeInteger.ValueInteger.of(2));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergyStoredInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_STORED, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergyStoredValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        helper.setBlock(POS.west().west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        ((BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class)).setEnergyStored(100);
        ((BlockEntityEnergyBattery)helper.getBlockEntity(POS.west().west(), BlockEntityEnergyBattery.class)).setEnergyStored(200);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_STORED, ValueTypeInteger.ValueInteger.of(300));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergyMaxInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_MAX, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergyMaxValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        helper.setBlock(POS.west().west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        ((BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class)).setEnergyStored(100);
        ((BlockEntityEnergyBattery)helper.getBlockEntity(POS.west().west(), BlockEntityEnergyBattery.class)).setEnergyStored(200);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_MAX, ValueTypeInteger.ValueInteger.of(2000000));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergConsumptionRateInvalid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_CONSUMPTION_RATE, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkEnergConsumptionRateValid(GameTestHelper helper) {
        GeneralConfig.energyConsumptionMultiplier = 1;
        Supplier<IAspectVariable> variableSupplier = GameTestHelpersIntegratedDynamics.testReadAspectSetup(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.INTEGER_ENERGY_CONSUMPTION_RATE);
        helper.succeedWhen(() -> {
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, (IVariable)variableSupplier.get(), (IValue)ValueTypeInteger.ValueInteger.of(2));
            GeneralConfig.energyConsumptionMultiplier = 0;
        });
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.NORTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.SOUTH, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkValueInvalidNoNetwork(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspectThrows(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.ANY_VALUE);
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkValueInvalidNoPart(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspectThrows(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.ANY_VALUE);
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkValueInvalidWrongSide(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.NORTH, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.NORTH), Aspects.Write.Redstone.BOOLEAN, new ItemStack(RegistryEntries.ITEM_VARIABLE));
        GameTestHelpersIntegratedDynamics.testReadAspectThrows(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.ANY_VALUE);
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkValueValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.west()), Direction.EAST), Aspects.Write.Redstone.BOOLEAN, new ItemStack(RegistryEntries.ITEM_VARIABLE));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.ANY_VALUE, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkGetVariableByIdInvalidId(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspectSetup(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.OPERATOR_GETVARIABLEBYID);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Network.OPERATOR_GETVARIABLEBYID);
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        helper.setBlock(POS.north().west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north().north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north().north(), BlockEntityVariablestore.class);
        variableStore.getInventory().setItem(0, variableAspect1);
        ItemStack variableConstant = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(10));
        variableStore.getInventory().setItem(1, variableConstant);
        ItemStack variableConstantId = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(-1));
        variableStore.getInventory().setItem(2, variableConstantId);
        ItemStack variableApplied = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.OPERATOR_APPLY, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableConstantId).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST), variableApplied);
        helper.succeedWhen(() -> {
            GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), null);
            helper.assertValueEqual(((PartTypePanelDisplay.State)partAndState.getRight()).getGlobalErrors(), (Object)Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"operator.integrateddynamics.error.variable_not_in_network", (Object[])new Object[]{Integer.toString(-1)})}), (Component)Component.literal((String)"Display panel errors do not match"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadNetworkGetVariableByIdValid(GameTestHelper helper) {
        GameTestHelpersIntegratedDynamics.testReadAspectSetup(POS, helper, PartTypes.NETWORK_READER, Aspects.Read.Network.OPERATOR_GETVARIABLEBYID);
        ItemStack variableAspect1 = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Network.OPERATOR_GETVARIABLEBYID);
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        helper.setBlock(POS.north().west(), (Block)RegistryEntries.BLOCK_CABLE.get());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_CABLE.get());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST, (IPartType)PartTypes.DISPLAY_PANEL, new ItemStack((ItemLike)PartTypes.DISPLAY_PANEL.getItem()));
        helper.setBlock(POS.north().north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north().north(), BlockEntityVariablestore.class);
        variableStore.getInventory().setItem(0, variableAspect1);
        ItemStack variableConstant = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(10));
        variableStore.getInventory().setItem(1, variableConstant);
        ItemStack variableConstantId = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableConstant).getId()));
        variableStore.getInventory().setItem(2, variableConstantId);
        ItemStack variableApplied = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.OPERATOR_APPLY, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableAspect1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableConstantId).getId()});
        Pair<PartTypePanelDisplay, PartTypePanelDisplay.State> partAndState = GameTestHelpersIntegratedDynamics.placeVariableInDisplayPanel((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.north()), Direction.EAST), variableApplied);
        helper.succeedWhen(() -> GameTestHelpersIntegratedDynamics.assertValueEqual(helper, ((PartTypePanelDisplay.State)partAndState.getRight()).getDisplayValue(), (IValue)ValueTypeInteger.ValueInteger.of(10)));
    }
}

