/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.item.ItemEnhancement;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsOffsets {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(4, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriter(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 4);
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posWriter, 4);
        boolean changedOffsetWriter = GameTestsOffsets.setOffset(posWriter, new Vec3i(2, 0, 0));
        helper.setBlock(POS.offset(-2, 0, 0).west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.offset(2, 0, 0).east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertTrue(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader failed"));
            helper.assertTrue(changedOffsetWriter, (Component)Component.literal((String)"Setting offset in writer failed"));
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(14));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriterOffset(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 4);
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posWriter, 4);
        boolean changedOffsetWriter = GameTestsOffsets.setOffset(posWriter, new Vec3i(2, 0, 0));
        helper.setBlock(POS.offset(-2, 0, 0).west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.offset(2, 0, 0).east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertTrue(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader failed"));
            helper.assertTrue(changedOffsetWriter, (Component)Component.literal((String)"Setting offset in writer failed"));
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(14));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriterOffsetAndSide(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 4);
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        GameTestsOffsets.setOffsetSide(posReader, Direction.SOUTH);
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posWriter, 4);
        boolean changedOffsetWriter = GameTestsOffsets.setOffset(posWriter, new Vec3i(2, 0, 0));
        GameTestsOffsets.setOffsetSide(posWriter, Direction.SOUTH);
        helper.setBlock(POS.offset(-2, 0, 0).west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.offset(2, 0, 0).east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertTrue(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader failed"));
            helper.assertTrue(changedOffsetWriter, (Component)Component.literal((String)"Setting offset in writer failed"));
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(14));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriterOnlySide(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 4);
        GameTestsOffsets.setOffsetSide(posReader, Direction.SOUTH);
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posWriter, 4);
        GameTestsOffsets.setOffsetSide(posWriter, Direction.SOUTH);
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(14));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Writer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)((Object)((Object)PartTypes.REDSTONE_WRITER.getBlockState(PartHelpers.getPartContainerChecked(PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST)), Direction.EAST).getValue(IgnoredBlockStatus.STATUS)))), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), Aspects.Write.Redstone.INTEGER, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(Aspects.Write.Redstone.INTEGER).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriterNoMaxOffset(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        boolean changedOffsetWriter = GameTestsOffsets.setOffset(posWriter, new Vec3i(2, 0, 0));
        helper.setBlock(POS.offset(-2, 0, 0).west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.offset(2, 0, 0).east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertFalse(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader did not fail"));
            helper.assertFalse(changedOffsetWriter, (Component)Component.literal((String)"Setting offset in writer did not fail"));
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsRedstoneReaderToWriterInsufficientMaxOffset(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 1);
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        PartPos posWriter = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST, (IPartType)PartTypes.REDSTONE_WRITER, new ItemStack((ItemLike)PartTypes.REDSTONE_WRITER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posWriter, 1);
        boolean changedOffsetWriter = GameTestsOffsets.setOffset(posWriter, new Vec3i(2, 0, 0));
        helper.setBlock(POS.offset(-2, 0, 0).west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west().below(), Blocks.STONE);
        helper.setBlock(POS.offset(-2, 0, 0).west().west().west(), Blocks.REDSTONE_TORCH);
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.WEST), Aspects.Read.Redstone.INTEGER_VALUE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter(helper, (Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.east()), Direction.EAST), Aspects.Write.Redstone.INTEGER, variableAspect);
        helper.setBlock(POS.offset(2, 0, 0).east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east().below(), Blocks.STONE);
        helper.setBlock(POS.offset(2, 0, 0).east().east().east(), Blocks.REDSTONE_WIRE);
        helper.succeedWhen(() -> {
            helper.assertFalse(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader did not fail"));
            helper.assertFalse(changedOffsetWriter, (Component)Component.literal((String)"Setting offset in writer did not fail"));
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.SIDE);
            helper.assertBlockProperty(POS.offset(2, 0, 0).east().east(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0));
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsDropOnBreak(GameTestHelper helper) {
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.above()), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.above()), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestsOffsets.increaseMaxOffset(helper, posReader, 4);
        boolean changedOffsetReader = GameTestsOffsets.setOffset(posReader, new Vec3i(-2, 0, 0));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        GameTestsOffsets.facePlayerToPart(player, posReader);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        helper.getBlockState(POS.above()).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS.above()), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS.above())));
        helper.succeedWhen(() -> {
            helper.assertTrue(changedOffsetReader, (Component)Component.literal((String)"Setting offset in reader failed"));
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityPresent((Item)RegistryEntries.ITEM_ENHANCEMENT_OFFSET.value());
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testOffsetsNoDropOnBreakWithoutOffsets(GameTestHelper helper) {
        helper.setBlock(POS.above(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.above().east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartPos posReader = PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS.above()), Direction.WEST);
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS.above()), Direction.WEST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.setShiftKeyDown(true);
        GameTestsOffsets.facePlayerToPart(player, posReader);
        player.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        helper.getBlockState(POS.above()).onDestroyedByPlayer((Level)helper.getLevel(), helper.absolutePos(POS.above()), player, true, helper.getLevel().getFluidState(helper.absolutePos(POS.above())));
        helper.succeedWhen(() -> {
            helper.assertItemEntityPresent(PartTypes.REDSTONE_READER.getItem());
            helper.assertItemEntityNotPresent((Item)RegistryEntries.ITEM_ENHANCEMENT_OFFSET.value());
        });
    }

    public static void increaseMaxOffset(GameTestHelper helper, PartPos partPos, int offset) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ENHANCEMENT_OFFSET.value());
        ((ItemEnhancement)((Object)RegistryEntries.ITEM_ENHANCEMENT_OFFSET.value())).setEnhancementValue(itemStack, offset);
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        GameTestsOffsets.facePlayerToPart(player, partPos);
        partPos.getPos().getLevel(true).getBlockState(partPos.getPos().getBlockPos()).useItemOn(itemStack, (Level)helper.getLevel(), player, InteractionHand.MAIN_HAND, new BlockHitResult(partPos.getPos().getBlockPos().getCenter(), partPos.getSide(), partPos.getPos().getBlockPos(), false));
    }

    public static void facePlayerToPart(Player player, PartPos partPos) {
        player.setYRot(partPos.getSide().getRotation().y() * 180.0f);
        player.setPos(partPos.getPos().getBlockPos().getCenter().add(0.0, -1.5, 0.0).add(Vec3.atLowerCornerOf((Vec3i)partPos.getSide().getUnitVec3i()).multiply(0.75, 0.75, 0.75)));
    }

    public static boolean setOffset(PartPos partPos, Vec3i offset) {
        PartHelpers.PartStateHolder<?, ?> partAndState = PartHelpers.getPart(partPos);
        return partAndState.getPart().setTargetOffset(partAndState.getState(), partPos, offset);
    }

    public static void setOffsetSide(PartPos partPos, Direction direction) {
        PartHelpers.PartStateHolder<?, ?> partAndState = PartHelpers.getPart(partPos);
        partAndState.getPart().setTargetSideOverride(partAndState.getState(), direction);
    }
}

