/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.Asserts;
import org.cyclops.integrateddynamics.gametest.integration.DummyValueType;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariable;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableBlock;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableItemStack;

public class TestBlockOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableBlock bAir;
    private DummyVariableBlock bCoal;
    private DummyVariableBlock bDarkOakLeaves;
    private DummyVariableBlock bLogicProgrammer;
    private DummyVariableBlock bLeaves;
    private DummyVariableBlock bReed;
    private DummyVariableBlock bSand;
    private DummyVariableBlock bFarmLand;
    private DummyVariableBlock bCarrot;
    private DummyVariableBlock bCarrotGrown;
    private DummyVariableItemStack iApple;
    private DummyVariableItemStack iSeedWheat;
    private DummyVariable<ValueTypeString.ValueString> sSponge;
    private DummyVariable<ValueTypeString.ValueString> sSand;
    private DummyVariable<ValueTypeNbt.ValueNbt> nbtCarrotGrown;

    @IntegrationBefore
    public void before() {
        this.bAir = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.AIR.defaultBlockState()));
        this.bCoal = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.COAL_BLOCK.defaultBlockState()));
        this.bDarkOakLeaves = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.DARK_OAK_LEAVES.defaultBlockState()));
        this.bLogicProgrammer = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(((Block)RegistryEntries.BLOCK_LOGIC_PROGRAMMER.get()).defaultBlockState()));
        this.bLeaves = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.OAK_LEAVES.defaultBlockState()));
        this.bReed = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.SUGAR_CANE.defaultBlockState()));
        this.bSand = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.SAND.defaultBlockState()));
        this.bFarmLand = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.FARMLAND.defaultBlockState()));
        this.bCarrot = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of(Blocks.CARROTS.defaultBlockState()));
        this.bCarrotGrown = new DummyVariableBlock(ValueObjectTypeBlock.ValueBlock.of((BlockState)Blocks.CARROTS.defaultBlockState().setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(1))));
        this.iApple = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.APPLE)));
        this.iSeedWheat = new DummyVariableItemStack(ValueObjectTypeItemStack.ValueItemStack.of(new ItemStack((ItemLike)Items.WHEAT_SEEDS)));
        this.sSponge = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:sponge"));
        this.sSand = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:sand"));
        CompoundTag tag = new CompoundTag();
        tag.putString("age", "1");
        this.nbtCarrotGrown = new DummyVariable<ValueTypeNbt.ValueNbt>(ValueTypes.NBT, ValueTypeNbt.ValueNbt.of((Tag)tag));
    }

    @IntegrationTest
    public void testBlockOpaque() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_OPAQUE.evaluate(this.bAir);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isopaque(air) = false");
        IValue res2 = Operators.OBJECT_BLOCK_OPAQUE.evaluate(this.bCoal);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isopaque(coalblock) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeOpaqueLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_OPAQUE.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeOpaqueSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_OPAQUE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeOpaque() throws EvaluationException {
        Operators.OBJECT_BLOCK_OPAQUE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockItemStack() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(this.bAir);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an itemstack");
        TestHelpers.assertEqual(!((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().isEmpty(), false, "itemstack(air) = null");
        IValue res2 = Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(this.bCoal);
        TestHelpers.assertEqual(ItemStack.isSameItem((ItemStack)((ValueObjectTypeItemStack.ValueItemStack)res2).getRawValue(), (ItemStack)new ItemStack((ItemLike)Blocks.COAL_BLOCK)), true, "itemstack(coalblock) = coalblock");
        IValue res3 = Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(this.bDarkOakLeaves);
        TestHelpers.assertEqual(ItemStack.isSameItem((ItemStack)((ValueObjectTypeItemStack.ValueItemStack)res3).getRawValue(), (ItemStack)new ItemStack((ItemLike)Blocks.DARK_OAK_LEAVES, 1)), true, "itemstack(dark_oak_leaves) = dark_oak_leaves");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemStackLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeItemStackSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeItemStack() throws EvaluationException {
        Operators.OBJECT_BLOCK_ITEMSTACK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockModName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_MODNAME.evaluate(this.bAir);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "Minecraft", "modname(air) = Minecraft");
        IValue res2 = Operators.OBJECT_BLOCK_MODNAME.evaluate(this.bLogicProgrammer);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), "IntegratedDynamics", "modname(logicprogrammer) = IntegratedDynamics");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_MODNAME.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_MODNAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeModName() throws EvaluationException {
        Operators.OBJECT_BLOCK_MODNAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockSound() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_BREAKSOUND.evaluate(this.bCoal);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), SoundEvents.STONE_BREAK.location().toString(), "placesound(coal) = inecraft:block.stone.break");
        IValue res2 = Operators.OBJECT_BLOCK_PLACESOUND.evaluate(this.bCoal);
        Asserts.check(res2 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), SoundEvents.STONE_PLACE.location().toString(), "placesound(coal) = inecraft:block.stone.place");
        IValue res3 = Operators.OBJECT_BLOCK_STEPSOUND.evaluate(this.bCoal);
        Asserts.check(res3 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res3).getRawValue(), SoundEvents.STONE_STEP.location().toString(), "placesound(coal) = inecraft:block.stone.step");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_BREAKSOUND.evaluate(this.bAir, this.bAir);
        Operators.OBJECT_BLOCK_PLACESOUND.evaluate(this.bAir, this.bAir);
        Operators.OBJECT_BLOCK_STEPSOUND.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_BREAKSOUND.evaluate(new IVariable[0]);
        Operators.OBJECT_BLOCK_PLACESOUND.evaluate(new IVariable[0]);
        Operators.OBJECT_BLOCK_STEPSOUND.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeSound() throws EvaluationException {
        Operators.OBJECT_BLOCK_BREAKSOUND.evaluate(DUMMY_VARIABLE);
        Operators.OBJECT_BLOCK_PLACESOUND.evaluate(DUMMY_VARIABLE);
        Operators.OBJECT_BLOCK_STEPSOUND.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockIsShearable() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_ISSHEARABLE.evaluate(this.bAir);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isshearable(air) = false");
        IValue res2 = Operators.OBJECT_BLOCK_ISSHEARABLE.evaluate(this.bLeaves);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "isshearable(leaves) = true");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsShearableLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_ISSHEARABLE.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsShearableSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_ISSHEARABLE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsShearable() throws EvaluationException {
        Operators.OBJECT_BLOCK_ISSHEARABLE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockPlantAge() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_PLANTAGE.evaluate(this.bAir);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 0, "plantage(air) = 0");
        IValue res2 = Operators.OBJECT_BLOCK_PLANTAGE.evaluate(this.bCarrot);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 0, "plantage(bCarrot) = 0");
        IValue res3 = Operators.OBJECT_BLOCK_PLANTAGE.evaluate(this.bCarrotGrown);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res3).getRawValue(), 1, "plantage(bCarrotGrown) = 1");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizePlantAgeLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_PLANTAGE.evaluate(this.bAir, this.bAir);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizePlantAgeSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_PLANTAGE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypePlantAge() throws EvaluationException {
        Operators.OBJECT_BLOCK_PLANTAGE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockBlockByName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_BY_NAME.evaluate(this.sSponge);
        Asserts.check(res1 instanceof ValueObjectTypeBlock.ValueBlock, "result is a block");
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res1).getRawValue().get(), Blocks.SPONGE.defaultBlockState(), "blockbyname(minecraft:sponge) = sponge");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockByNameLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_BY_NAME.evaluate(this.sSponge, this.sSponge);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockByNameSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_BY_NAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlockByName() throws EvaluationException {
        Operators.OBJECT_BLOCK_BY_NAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockBlockProperties() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_PROPERTIES.evaluate(this.bCarrotGrown);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an nbt tag");
        CompoundTag tag = new CompoundTag();
        tag.putString("age", "1");
        TestHelpers.assertEqual((Tag)((ValueTypeNbt.ValueNbt)res1).getRawValue().get(), tag, "blockproperties(minecraft:carrot) = {...}");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockPropertiesLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_PROPERTIES.evaluate(this.bLeaves, this.bLeaves);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockPropertiesSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_PROPERTIES.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlockProperties() throws EvaluationException {
        Operators.OBJECT_BLOCK_PROPERTIES.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockBlockWithProperties() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_WITH_PROPERTIES.evaluate(this.bCarrot, this.nbtCarrotGrown);
        Asserts.check(res1 instanceof ValueObjectTypeBlock.ValueBlock, "result is a block");
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res1).getRawValue().get(), (BlockState)((ValueObjectTypeBlock.ValueBlock)this.bCarrotGrown.getValue()).getRawValue().get(), "blockwithproperties(minecraft:carrot, ...) = {...}");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockWithPropertiesLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_WITH_PROPERTIES.evaluate(this.bLeaves, this.nbtCarrotGrown, this.bLeaves);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockWithPropertiesSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_WITH_PROPERTIES.evaluate(this.bLeaves);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlockWithProperties() throws EvaluationException {
        Operators.OBJECT_BLOCK_WITH_PROPERTIES.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockBlockPossibleProperties() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_POSSIBLE_PROPERTIES.evaluate(this.bCarrotGrown);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an nbt tag");
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        list.add((Object)StringTag.valueOf((String)"0"));
        list.add((Object)StringTag.valueOf((String)"1"));
        list.add((Object)StringTag.valueOf((String)"2"));
        list.add((Object)StringTag.valueOf((String)"3"));
        list.add((Object)StringTag.valueOf((String)"4"));
        list.add((Object)StringTag.valueOf((String)"5"));
        list.add((Object)StringTag.valueOf((String)"6"));
        list.add((Object)StringTag.valueOf((String)"7"));
        tag.put("age", (Tag)list);
        TestHelpers.assertEqual((Tag)((ValueTypeNbt.ValueNbt)res1).getRawValue().get(), tag, "blockpossibleproperties(minecraft:carrot) = {...}");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockPossiblePropertiesLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_POSSIBLE_PROPERTIES.evaluate(this.bLeaves, this.bLeaves);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockPossiblePropertiesSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_POSSIBLE_PROPERTIES.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlockPossibleProperties() throws EvaluationException {
        Operators.OBJECT_BLOCK_POSSIBLE_PROPERTIES.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockTag() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_TAG.evaluate(this.bSand);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 19, "size(tag(sand)) = 19");
        IValue res2 = Operators.OBJECT_BLOCK_TAG.evaluate(this.bLeaves);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 8, "size(tag(leaves)) = 8");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG.evaluate(this.bLeaves, this.bLeaves);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTag() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlockTagStacks() throws EvaluationException {
        IValue res1 = Operators.OBJECT_BLOCK_TAG_STACKS.evaluate(this.sSand);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), (int)Helpers.getBlockTagValues("minecraft:sand").count(), "size(tag_stacks(sand))");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksLarge() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG_STACKS.evaluate(this.sSand, this.sSand);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksSmall() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG_STACKS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTagStacks() throws EvaluationException {
        Operators.OBJECT_BLOCK_TAG_STACKS.evaluate(DUMMY_VARIABLE);
    }
}

