/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.ItemLike;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.display.RecipeDisplaySqueezer;
import org.cyclops.integrateddynamics.infobook.pageelement.SqueezerRecipeAppendixClient;

public class SqueezerRecipeAppendix
extends RecipeAppendix<SqueezerRecipeAppendixClient> {
    public static final int SLOT_INPUT_OFFSET_X = 16;
    public static final int SLOT_OFFSET_Y = 23;
    public static final int SLOT_OUTPUT_OFFSET_X = 68;
    public static final AdvancedButtonEnum INPUT_ITEM = AdvancedButtonEnum.create();
    public static final AdvancedButtonEnum RESULT_FLUID = AdvancedButtonEnum.create();
    private List<AdvancedButtonEnum> resultItems;

    public SqueezerRecipeAppendix(IInfoBook infoBook, Supplier<RecipeDisplayEntry> recipeDisplaySupplier) throws InfoBookParser.InvalidAppendixException {
        super(infoBook, recipeDisplaySupplier);
    }

    public List<AdvancedButtonEnum> getResultItems() {
        return this.resultItems;
    }

    protected int getWidth() {
        return 100;
    }

    public SqueezerRecipeAppendixClient constructSectionAppendixClient() throws InfoBookParser.InvalidAppendixException {
        return new SqueezerRecipeAppendixClient(this);
    }

    protected int getHeightInner() {
        RecipeDisplayEntry recipeDisplay = this.getRecipeDisplay();
        if (recipeDisplay == null) {
            return 10;
        }
        return (!((RecipeDisplaySqueezer)recipeDisplay.display()).outputFluid().isEmpty() ? 23 : 0) + ((RecipeDisplaySqueezer)recipeDisplay.display()).outputItems().size() * 23 - 3;
    }

    protected String getUnlocalizedTitle() {
        return "block.integrateddynamics.squeezer";
    }

    public void bakeElement(InfoSection infoSection) {
        this.resultItems = Lists.newArrayList();
        RecipeDisplayEntry recipeDisplay = this.getRecipeDisplay();
        if (recipeDisplay == null) {
            return;
        }
        RecipeDisplaySqueezer display = (RecipeDisplaySqueezer)recipeDisplay.display();
        for (int i = 0; i < display.outputItems().size(); ++i) {
            this.resultItems.add(AdvancedButtonEnum.create());
        }
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            ((SqueezerRecipeAppendixClient)this.getSectionAppendixClient()).bakeElement(infoSection);
        }
        super.bakeElement(infoSection);
    }

    protected ItemStack getCrafter() {
        return new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER.get());
    }
}

