/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.event.PartVariableDrivenVariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.part.panel.PartTypePanelVariableDriven;

public class ContainerPartPanelVariableDriven<P extends PartTypePanelVariableDriven<P, S>, S extends PartTypePanelVariableDriven.State<P, S>>
extends ContainerMultipart<P, S> {
    private static final int SLOT_X = 79;
    private static final int SLOT_Y = 8;
    private final int readValueId = this.getNextValueId();
    private final int readColorId = this.getNextValueId();
    private final int readErrorsId = this.getNextValueId();

    public ContainerPartPanelVariableDriven(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(packetBuffer.readInt()), Optional.empty(), Optional.empty(), (PartTypePanelVariableDriven)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartPanelVariableDriven(int id, Inventory playerInventory, Container inventory, Optional<PartTarget> target, Optional<IPartContainer> partContainer, P partType) {
        super((MenuType)RegistryEntries.CONTAINER_PART_DISPLAY.get(), id, playerInventory, inventory, target, partContainer, partType);
        if (inventory instanceof SimpleInventory) {
            ((SimpleInventory)inventory).addDirtyMarkListener((IDirtyMarkListener)this);
        }
        this.addInventory(inventory, 0, 80, 14, 1, 1);
        this.addPlayerInventory(this.player.getInventory(), 8, 46);
    }

    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        if (inventory instanceof SimpleInventory) {
            return new SlotVariable(inventory, index, x, y);
        }
        return super.createNewSlot(inventory, index, x, y);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.level().isClientSide()) {
            MutableComponent readValue = Component.literal((String)"");
            int readValueColor = 0;
            if (!NetworkHelpers.shouldWork()) {
                readValue = Component.literal((String)"SAFE-MODE");
            } else {
                IValue value = ((PartTypePanelVariableDriven.State)this.getPartState().get()).getDisplayValue();
                if (value != null) {
                    readValue = value.getType().toCompactString(value);
                    readValueColor = value.getType().getDisplayColor();
                }
            }
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readValueId, (Component)readValue);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readColorId, (int)readValueColor);
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.readErrorsId, ((PartTypePanelVariableDriven.State)this.getPartState().get()).getGlobalErrors());
        }
    }

    @Override
    public void onDirty() {
        if (!this.player.level().isClientSide()) {
            PartTypePanelVariableDriven.State partState = (PartTypePanelVariableDriven.State)this.getPartState().get();
            partState.onVariableContentsUpdated((PartTypePanelVariableDriven)this.getPartType(), this.getTarget().get());
            Optional<INetwork> optionalNetwork = NetworkHelpers.getNetwork(this.getTarget().get().getCenter());
            if (!this.getContainerInventory().isEmpty()) {
                NetworkHelpers.getPartNetwork(optionalNetwork).ifPresent(partNetwork -> {
                    try {
                        INetwork network = optionalNetwork.orElse(null);
                        IVariable variable = partState.getVariable(network, (IPartNetwork)partNetwork, ValueDeseralizationContext.of(this.player.level()));
                        NeoForge.EVENT_BUS.post(new PartVariableDrivenVariableContentsUpdatedEvent<PartTypePanelVariableDriven, PartTypePanelVariableDriven.State>(network, (IPartNetwork)partNetwork, this.getTarget().get(), (PartTypePanelVariableDriven)this.getPartType(), partState, this.player, variable, variable != null ? (IValue)variable.getValue() : null));
                    }
                    catch (EvaluationException evaluationException) {
                        // empty catch block
                    }
                });
            }
            optionalNetwork.ifPresent(network -> network.getEventBus().post(new VariableContentsUpdatedEvent((INetwork)network)));
        }
    }

    public void removed(Player player) {
        super.removed(player);
        if (this.inventory instanceof SimpleInventory) {
            ((SimpleInventory)this.inventory).removeDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    public Component getReadValue() {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.readValueId);
    }

    public int getReadValueColor() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.readColorId);
    }

    public List<Component> getReadErrors() {
        return ValueNotifierHelpers.getValueTextComponentList((IValueNotifier)this, (int)this.readErrorsId);
    }
}

